/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process.valign;

import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.RenderableReplacedContent;
import org.jfree.layouting.renderer.process.valign.AlignContext;
import org.jfree.layouting.util.geom.StrictDimension;

public class ReplacedContentAlignContext
extends AlignContext {
    private long shift;
    private long height;

    public ReplacedContentAlignContext(RenderableReplacedContent renderableReplacedContent) {
        super(renderableReplacedContent);
        StrictDimension strictDimension = renderableReplacedContent.getContentSize();
        if (RenderLength.AUTO.equals(renderableReplacedContent.getRequestedWidth())) {
            if (RenderLength.AUTO.equals(renderableReplacedContent.getRequestedHeight())) {
                this.height = strictDimension.getHeight();
            } else {
                RenderLength renderLength = renderableReplacedContent.getComputedLayoutProperties().getBlockContextWidth();
                this.height = renderableReplacedContent.getRequestedHeight().resolve(renderLength.resolve(0L));
            }
        } else if (RenderLength.AUTO.equals(renderableReplacedContent.getRequestedHeight())) {
            if (strictDimension.getWidth() > 0L) {
                RenderLength renderLength = renderableReplacedContent.getComputedLayoutProperties().getBlockContextWidth();
                long l = renderableReplacedContent.getRequestedWidth().resolve(renderLength.resolve(0L));
                this.height = l * strictDimension.getHeight() / strictDimension.getWidth();
            } else {
                this.height = 0L;
            }
        } else {
            RenderLength renderLength = renderableReplacedContent.getComputedLayoutProperties().getBlockContextWidth();
            this.height = renderableReplacedContent.getRequestedHeight().resolve(renderLength.resolve(0L));
        }
    }

    @Override
    public long getBaselineDistance(int n) {
        if (n == 0) {
            return 0L;
        }
        if (n == 1) {
            return 0L;
        }
        return this.height;
    }

    @Override
    public void shift(long l) {
        this.shift += l;
    }

    @Override
    public long getAfterEdge() {
        return this.shift + this.height;
    }

    @Override
    public long getBeforeEdge() {
        return this.shift;
    }
}

