/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.codelinks.highlight;

import com.almworks.tracklink.codelinks.cache.ArtifactInfoCache;
import com.almworks.tracklink.codelinks.highlight.CodeParser;
import com.almworks.tracklink.codelinks.highlight.EditorInputHandler;
import com.almworks.tracklink.codelinks.highlight.URLTextRange;
import com.almworks.tracklink.filemonitoring.PsiTreeChangeChecker;
import com.almworks.tracklink.util.Utils;
import com.almworks.util.threads.AWTBottleneck;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.almworks.util.detach.Detach;
import org.almworks.util.detach.Lifecycle;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsiLinkHighlighter {
    private final Editor myEditor;
    private final PsiFile myPsiFile;
    private final CodeParser myParser;
    private final ArtifactInfoCache myCache;
    private final Lifecycle myLifespan;
    private final AWTBottleneck myBottleneck;
    private final List<URLTextRange> myRanges;

    public PsiLinkHighlighter(@NotNull Editor editor, @NotNull PsiFile psiFile, @NotNull CodeParser parser, @NotNull ArtifactInfoCache cache) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/codelinks/highlight/PsiLinkHighlighter.<init> must not be null");
        }
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/almworks/tracklink/codelinks/highlight/PsiLinkHighlighter.<init> must not be null");
        }
        if (parser == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/almworks/tracklink/codelinks/highlight/PsiLinkHighlighter.<init> must not be null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/almworks/tracklink/codelinks/highlight/PsiLinkHighlighter.<init> must not be null");
        }
        this.myLifespan = new Lifecycle();
        this.myBottleneck = new AWTBottleneck(50L, new Runnable(){

            public void run() {
                PsiLinkHighlighter.this.checkComments();
            }
        });
        this.myRanges = new ArrayList<URLTextRange>();
        this.myEditor = editor;
        this.myPsiFile = psiFile;
        this.myParser = parser;
        this.myCache = cache;
    }

    public boolean isMyEditor(Editor editor) {
        return editor == this.myEditor;
    }

    public boolean isMyPsiFile(PsiFile file) {
        return file == this.myPsiFile;
    }

    public void startListen() {
        this.myLifespan.cycle();
        this.listenInput();
        this.listenDocument();
        this.listenPsiChanges();
        this.reparseAll();
        this.checkComments();
    }

    public void reparseAll() {
        int l = this.myEditor.getDocument().getCharsSequence().length();
        this.parseRanges(0, l, l);
    }

    public void stopListen() {
        this.myLifespan.cycle();
    }

    private void listenInput() {
        final EditorInputHandler inputHandler = new EditorInputHandler(this.myEditor, this.myPsiFile, this.myParser, this.myCache);
        this.myEditor.addEditorMouseMotionListener((EditorMouseMotionListener)inputHandler);
        this.myEditor.getContentComponent().addKeyListener(inputHandler);
        this.myLifespan.lifespan().add(new Detach(){

            protected void doDetach() {
                PsiLinkHighlighter.this.myEditor.removeEditorMouseMotionListener((EditorMouseMotionListener)inputHandler);
                PsiLinkHighlighter.this.myEditor.getContentComponent().removeKeyListener(inputHandler);
            }
        });
    }

    public void addDocumentListener(final DocumentListener listener) {
        this.myEditor.getDocument().addDocumentListener(listener);
        this.myLifespan.lifespan().add(new Detach(){

            protected void doDetach() {
                PsiLinkHighlighter.this.myEditor.getDocument().removeDocumentListener(listener);
            }
        });
    }

    private void listenDocument() {
        final Document document = this.myEditor.getDocument();
        final DocumentAdapter documentListener = new DocumentAdapter(){

            public void beforeDocumentChange(DocumentEvent e) {
                if (e.getNewLength() < e.getOldLength()) {
                    PsiLinkHighlighter.this.forgetRanges(e.getOffset(), e.getOffset() + e.getOldLength());
                }
            }

            public void documentChanged(DocumentEvent e) {
                PsiLinkHighlighter.this.parseRanges(e.getOffset(), e.getOldLength(), e.getNewLength());
            }
        };
        document.addDocumentListener((DocumentListener)documentListener);
        this.myLifespan.lifespan().add(new Detach(){

            protected void doDetach() {
                document.removeDocumentListener((DocumentListener)documentListener);
            }
        });
    }

    private void listenPsiChanges() {
        final PsiTreeChangeChecker treeChangeChecker = new PsiTreeChangeChecker(){

            public void run() {
                PsiLinkHighlighter.this.myBottleneck.requestDelayed();
            }
        };
        this.myPsiFile.getManager().addPsiTreeChangeListener((PsiTreeChangeListener)treeChangeChecker);
        this.myLifespan.lifespan().add(new Detach(){

            protected void doDetach() {
                PsiLinkHighlighter.this.myPsiFile.getManager().removePsiTreeChangeListener((PsiTreeChangeListener)treeChangeChecker);
            }
        });
    }

    private void parseRanges(int eventOffset, int oldLength, int newLength) {
        List<URLTextRange> newRanges = this.myParser.getURLTextRanges(this.myEditor, Utils.getStartLineOffset(this.myEditor, eventOffset), Utils.getEndLineOffset(this.myEditor, eventOffset + newLength));
        ArrayList<URLTextRange> rangesToForget = new ArrayList<URLTextRange>();
        List<URLTextRange> intersectingRanges = this.getIntersectingAndBoundedRanges(eventOffset, oldLength);
        if (newLength != oldLength) {
            this.shiftRanges(eventOffset, newLength - oldLength);
        }
        for (URLTextRange oldRange : intersectingRanges) {
            boolean oldRangeContainsInNews = false;
            for (URLTextRange newRange : newRanges) {
                if (!newRange.equals(oldRange)) continue;
                oldRangeContainsInNews = true;
                break;
            }
            if (oldRangeContainsInNews) continue;
            rangesToForget.add(oldRange);
        }
        if (!rangesToForget.isEmpty()) {
            for (URLTextRange urlTextRange : rangesToForget) {
                urlTextRange.setActive(false);
                this.myRanges.remove(urlTextRange);
            }
            this.doStaticHighlighting(rangesToForget);
        }
        if (!newRanges.isEmpty()) {
            ArrayList<URLTextRange> rangesToMemorize = new ArrayList<URLTextRange>();
            ArrayList<String> newUrls = new ArrayList<String>();
            for (URLTextRange range : newRanges) {
                if (this.myRanges.contains(range)) continue;
                rangesToMemorize.add(range);
                newUrls.add(range.getCodeLink().getUrl());
            }
            if (!rangesToMemorize.isEmpty()) {
                this.myRanges.addAll(rangesToMemorize);
                Editor editor = this.myEditor;
                if (editor != null) {
                    Project project = editor.getProject();
                    this.myCache.getListModel((Object)this, project, this.myLifespan.lifespan(), newUrls);
                }
            }
        }
    }

    private void shiftRanges(int eventOffset, int shiftValue) {
        for (URLTextRange range : this.myRanges) {
            if (range.getStartOffset() < eventOffset) continue;
            range.shift(shiftValue);
        }
    }

    private List<URLTextRange> getIntersectingAndBoundedRanges(int eventOffset, int oldLength) {
        ArrayList<URLTextRange> result = new ArrayList<URLTextRange>();
        for (URLTextRange range : this.myRanges) {
            if (!Utils.intersectOrBound(range.getStartOffset(), range.getEndOffset(), eventOffset, eventOffset + oldLength)) continue;
            result.add(range);
        }
        return result;
    }

    private void forgetRanges(int startOffset, int endOffset) {
        ArrayList<URLTextRange> rangesToForget = new ArrayList<URLTextRange>();
        for (URLTextRange range : this.myRanges) {
            if (!Utils.intersect(startOffset, endOffset, range.getStartOffset(), range.getEndOffset())) continue;
            rangesToForget.add(range);
        }
        if (!rangesToForget.isEmpty()) {
            for (URLTextRange urlTextRange : rangesToForget) {
                urlTextRange.setActive(false);
                this.myRanges.remove(urlTextRange);
            }
            this.doStaticHighlighting(rangesToForget);
        }
    }

    public void checkComments() {
        ArrayList<URLTextRange> changedRanges = new ArrayList<URLTextRange>();
        for (URLTextRange urlTextRange : this.myRanges) {
            boolean isComment = CodeParser.isComment(this.myPsiFile, urlTextRange.getStartOffset());
            if (isComment == urlTextRange.isActive()) continue;
            urlTextRange.setActive(isComment);
            changedRanges.add(urlTextRange);
        }
        if (!changedRanges.isEmpty()) {
            this.doStaticHighlighting(changedRanges);
        }
    }

    private void doStaticHighlighting(List<URLTextRange> urlTextRanges) {
        RangeHighlighter[] allHighlighters;
        MarkupModel markupModel = this.myEditor.getMarkupModel();
        for (RangeHighlighter highlighter : allHighlighters = markupModel.getAllHighlighters()) {
            URLTextRange textRange = URLTextRange.getFrom(highlighter);
            if (textRange == null || !urlTextRanges.contains(textRange) || textRange.isActive()) continue;
            markupModel.removeHighlighter(highlighter);
        }
        for (URLTextRange urlTextRange : urlTextRanges) {
            if (!urlTextRange.isActive()) continue;
            urlTextRange.addStaticHighlighter(this.myEditor);
        }
    }
}

