/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.findusages;

import com.almworks.tracklink.codelinks.highlight.URLTextRange;
import com.almworks.tracklink.util.PluginIcons;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.vcslinks.VCSUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInLibrary;
import com.intellij.usages.rules.UsageInModule;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CodeLinkUsage
implements Usage,
UsageInModule,
UsageInLibrary,
UsageInFile,
PsiElementUsage,
MergeableUsage {
    private final UsageInfo2UsageAdapter myAdapter;
    private final CodeLinkUsagePresentation myPresentation;
    private final List<RangeMarker> myRangeMarkers = new ArrayList<RangeMarker>();
    private final URLTextRange myTextRange;

    public CodeLinkUsage(UsageInfo usageInfo, URLTextRange textRange) {
        this.myTextRange = textRange;
        this.myAdapter = new UsageInfo2UsageAdapter(usageInfo);
        this.myPresentation = new CodeLinkUsagePresentation();
        PsiElement element = usageInfo.getElement();
        if (element != null) {
            PsiFile psiFile = element.getContainingFile();
            Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(psiFile);
            this.myRangeMarkers.add(document.createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset()));
        }
    }

    public boolean isValid() {
        return this.myAdapter.isValid();
    }

    public boolean isReadOnly() {
        return this.myAdapter.isReadOnly();
    }

    public FileEditorLocation getLocation() {
        return this.myAdapter.getLocation();
    }

    public void selectInEditor() {
        this.myAdapter.selectInEditor();
    }

    public void highlightInEditor() {
        this.myAdapter.highlightInEditor();
    }

    public UsagePresentation getPresentation() {
        return this.myPresentation;
    }

    public void navigate(boolean requestFocus) {
        this.myAdapter.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myAdapter.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myAdapter.canNavigateToSource();
    }

    public Module getModule() {
        return this.myAdapter.getModule();
    }

    public OrderEntry getLibraryEntry() {
        return this.myAdapter.getLibraryEntry();
    }

    public VirtualFile getFile() {
        VirtualFile file = this.myAdapter.getFile();
        if (file != null) {
            file.putUserData(VCSUtil.VCS_DIFFERENCE_TYPE, null);
            file.putUserData(VCSUtil.VCS_MODIFICATION_DATE, null);
        }
        return file;
    }

    public PsiElement getElement() {
        PsiElement element = this.myAdapter.getElement();
        return element != null ? element.getContainingFile() : null;
    }

    public boolean isNonCodeUsage() {
        return this.myAdapter.isNonCodeUsage();
    }

    public boolean merge(MergeableUsage mergeableUsage) {
        return this.myAdapter.merge(mergeableUsage);
    }

    public void reset() {
        this.myAdapter.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CodeLinkUsagePresentation
    implements UsagePresentation {
        private CodeLinkUsagePresentation() {
        }

        public String getTooltipText() {
            return StringBundle.get("find.tooltip.codelink", CodeLinkUsage.this.myTextRange.getCodeLink().getUrl());
        }

        public TextChunk[] getText() {
            if (CodeLinkUsage.this.getElement() == null) {
                return new TextChunk[]{new TextChunk(null, "")};
            }
            return new ChunkExtractor(CodeLinkUsage.this.myAdapter.getElement(), CodeLinkUsage.this.myRangeMarkers).extractChunks();
        }

        private int getStartOffset(List<RangeMarker> rangeMarkers) {
            assert (!rangeMarkers.isEmpty());
            int minStart = Integer.MAX_VALUE;
            for (RangeMarker rangeMarker : rangeMarkers) {
                int startOffset = rangeMarker.getStartOffset();
                if (startOffset >= minStart) continue;
                minStart = startOffset;
            }
            return minStart;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public String getPlainText() {
            int startOffset = this.getStartOffset(CodeLinkUsage.this.myRangeMarkers);
            PsiElement element = CodeLinkUsage.this.getElement();
            if (element == null) return "";
            Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile());
            if (document == null) return "";
            int lineNumber = document.getLineNumber(startOffset);
            int lineStart = document.getLineStartOffset(lineNumber);
            int lineEnd = document.getLineEndOffset(lineNumber);
            String string = ((Object)document.getCharsSequence().subSequence(lineStart, lineEnd)).toString();
            String string2 = string;
            if (string == null) throw new IllegalStateException("@NotNull method com/almworks/tracklink/findusages/CodeLinkUsage$CodeLinkUsagePresentation.getPlainText must not return null");
            return string2;
        }

        public Icon getIcon() {
            return PluginIcons.BUG;
        }
    }
}

