/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelDirectedPlayer;
import com.sun.media.sound.ModelDirector;
import com.sun.media.sound.ModelPerformer;
import java.util.Arrays;

public final class ModelStandardDirector
implements ModelDirector {
    private final ModelPerformer[] performers;
    private final ModelDirectedPlayer player;
    private boolean noteOnUsed = false;
    private boolean noteOffUsed = false;

    public ModelStandardDirector(ModelPerformer[] modelPerformerArray, ModelDirectedPlayer modelDirectedPlayer) {
        this.performers = Arrays.copyOf(modelPerformerArray, modelPerformerArray.length);
        this.player = modelDirectedPlayer;
        for (ModelPerformer modelPerformer : this.performers) {
            if (modelPerformer.isReleaseTriggered()) {
                this.noteOffUsed = true;
                continue;
            }
            this.noteOnUsed = true;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void noteOff(int n, int n2) {
        if (!this.noteOffUsed) {
            return;
        }
        for (int i = 0; i < this.performers.length; ++i) {
            ModelPerformer modelPerformer = this.performers[i];
            if (modelPerformer.getKeyFrom() > n || modelPerformer.getKeyTo() < n || modelPerformer.getVelFrom() > n2 || modelPerformer.getVelTo() < n2 || !modelPerformer.isReleaseTriggered()) continue;
            this.player.play(i, null);
        }
    }

    @Override
    public void noteOn(int n, int n2) {
        if (!this.noteOnUsed) {
            return;
        }
        for (int i = 0; i < this.performers.length; ++i) {
            ModelPerformer modelPerformer = this.performers[i];
            if (modelPerformer.getKeyFrom() > n || modelPerformer.getKeyTo() < n || modelPerformer.getVelFrom() > n2 || modelPerformer.getVelTo() < n2 || modelPerformer.isReleaseTriggered()) continue;
            this.player.play(i, null);
        }
    }
}

