"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = exports.config = void 0;
exports.plugin = plugin;

var _configSchema = require("@osd/config-schema");

var _plugin = require("./plugin");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
const configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  })
});

exports.configSchema = configSchema;
const config = {
  exposeToBrowser: {
    enabled: true
  },
  schema: configSchema
};
exports.config = config;

function plugin(initializerContext) {
  return new _plugin.AnomalyDetectionOpenSearchDashboardsPlugin(initializerContext);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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