"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _constants = require("../../utils/constants");

var _configSchema = require("@osd/config-schema");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function _default(services, router) {
  const {
    snapshotManagementService
  } = services;
  router.get({
    path: _constants.NODE_API._SNAPSHOTS,
    validate: {}
  }, snapshotManagementService.getAllSnapshotsWithPolicy);
  router.get({
    path: `${_constants.NODE_API._SNAPSHOTS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        repository: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.getSnapshot);
  router.delete({
    path: `${_constants.NODE_API._SNAPSHOTS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        repository: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.deleteSnapshot);
  router.put({
    path: `${_constants.NODE_API._SNAPSHOTS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        repository: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, snapshotManagementService.createSnapshot);
  router.post({
    path: `${_constants.NODE_API._SNAPSHOTS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        repository: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, snapshotManagementService.restoreSnapshot);
  router.post({
    path: `${_constants.NODE_API.SMPolicies}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, snapshotManagementService.createPolicy);
  router.put({
    path: `${_constants.NODE_API.SMPolicies}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        seqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        primaryTerm: _configSchema.schema.maybe(_configSchema.schema.number())
      }),
      body: _configSchema.schema.any()
    }
  }, snapshotManagementService.updatePolicy);
  router.get({
    path: _constants.NODE_API.SMPolicies,
    validate: {
      // for public service to pass object to server service
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        sortField: _configSchema.schema.string(),
        sortOrder: _configSchema.schema.string(),
        queryString: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.getPolicies);
  router.get({
    path: `${_constants.NODE_API.SMPolicies}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.getPolicy);
  router.delete({
    path: `${_constants.NODE_API.SMPolicies}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.deletePolicy);
  router.post({
    path: `${_constants.NODE_API.SMPolicies}/{id}/_start`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.startPolicy);
  router.post({
    path: `${_constants.NODE_API.SMPolicies}/{id}/_stop`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.stopPolicy);
  router.get({
    path: _constants.NODE_API._REPOSITORIES,
    validate: {}
  }, snapshotManagementService.catRepositoriesWithSnapshotCount);
  router.get({
    path: `${_constants.NODE_API._INDICES}/{indices}`,
    validate: {
      params: _configSchema.schema.object({
        indices: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.catSnapshotIndices);
  router.get({
    path: _constants.NODE_API._RECOVERY,
    validate: {}
  }, snapshotManagementService.getIndexRecovery);
  router.delete({
    path: `${_constants.NODE_API._REPOSITORIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.deleteRepository);
  router.get({
    path: `${_constants.NODE_API._REPOSITORIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.getRepository);
  router.put({
    path: `${_constants.NODE_API._REPOSITORIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, snapshotManagementService.createRepository);
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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