/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.metadata;

import java.util.List;
import org.olap4j.OlapException;
import org.olap4j.metadata.DictionaryImpl;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Property;
import org.olap4j.metadata.XmlaConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Level
extends MetadataElement {
    public int getDepth();

    public Hierarchy getHierarchy();

    public Dimension getDimension();

    public Type getLevelType();

    public boolean isCalculated();

    public NamedList<Property> getProperties();

    public List<Member> getMembers() throws OlapException;

    public int getCardinality();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type implements XmlaConstant
    {
        REGULAR(0),
        ALL(1),
        NULL(-1),
        TIME_YEARS(20),
        TIME_HALF_YEAR(36),
        TIME_QUARTERS(68),
        TIME_MONTHS(132),
        TIME_WEEKS(260),
        TIME_DAYS(516),
        TIME_HOURS(772),
        TIME_MINUTES(1028),
        TIME_SECONDS(2052),
        TIME_UNDEFINED(4100),
        GEO_CONTINENT(8193),
        GEO_REGION(8194),
        GEO_COUNTRY(8195),
        GEO_STATE_OR_PROVINCE(8196),
        GEO_COUNTY(8197),
        GEO_CITY(8198),
        GEO_POSTALCODE(8199),
        GEO_POINT(8200),
        ORG_UNIT(4113),
        BOM_RESOURCE(4114),
        QUANTITATIVE(4115),
        ACCOUNT(4116),
        CUSTOMER(4129),
        CUSTOMER_GROUP(4130),
        CUSTOMER_HOUSEHOLD(4131),
        PRODUCT(4145),
        PRODUCT_GROUP(4146),
        SCENARIO(4117),
        UTILITY(4118),
        PERSON(4161),
        COMPANY(4162),
        CURRENCY_SOURCE(4177),
        CURRENCY_DESTINATION(4178),
        CHANNEL(4193),
        REPRESENTATIVE(4194),
        PROMOTION(4209);

        private final int xmlaOrdinal;
        private static final XmlaConstant.Dictionary<Type> DICTIONARY;

        public static XmlaConstant.Dictionary<Type> getDictionary() {
            return DICTIONARY;
        }

        private Type(int xmlaOrdinal) {
            this.xmlaOrdinal = xmlaOrdinal;
        }

        @Override
        public String xmlaName() {
            return "MDLEVEL_TYPE_" + this.name();
        }

        @Override
        public String getDescription() {
            return "";
        }

        @Override
        public int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }

        public boolean isTime() {
            switch (this) {
                case TIME_YEARS: 
                case TIME_HALF_YEAR: 
                case TIME_QUARTERS: 
                case TIME_MONTHS: 
                case TIME_WEEKS: 
                case TIME_DAYS: 
                case TIME_HOURS: 
                case TIME_MINUTES: 
                case TIME_SECONDS: 
                case TIME_UNDEFINED: {
                    return true;
                }
            }
            return false;
        }

        static {
            DICTIONARY = DictionaryImpl.forClass(Type.class);
        }
    }
}

