/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao.upgrade;

import ca.sqlpower.dao.SPUpgradePersister;
import ca.sqlpower.dao.upgrade.UpgradePersisterManager;
import java.util.ArrayList;

public abstract class AbstractUpgradePersisterManager
implements UpgradePersisterManager {
    private ArrayList<SPUpgradePersister> upgradePersisters = new ArrayList();

    protected void registerUpgradePersister(int oldVersion, SPUpgradePersister upgradePersister) {
        if (oldVersion < this.upgradePersisters.size()) {
            throw new IllegalArgumentException("A persister is already registered to upgrade repositories from version " + oldVersion);
        }
        if (oldVersion == 0) {
            this.upgradePersisters.add(oldVersion, upgradePersister);
        } else if (oldVersion == this.upgradePersisters.size()) {
            this.upgradePersisters.add(oldVersion, upgradePersister);
            this.upgradePersisters.get(oldVersion - 1).setNextPersister(upgradePersister, true);
        } else {
            throw new IllegalArgumentException("There is no persister at revision " + (oldVersion - 1) + " to chain this persister to.");
        }
    }

    @Override
    public SPUpgradePersister getUpgradePersister(int version) {
        if (version >= this.getStateVersion()) {
            return null;
        }
        return this.upgradePersisters.get(version);
    }
}

