/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl;

import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandResolver;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.parser.LineParser;
import org.aesh.parser.ParsedLine;

public class AeshCommandResolver<CI extends CommandInvocation>
implements CommandResolver<CI> {
    private CommandRegistry<CI> registry;
    private LineParser lineParser;

    public AeshCommandResolver(CommandRegistry<CI> commandRegistry) {
        this.registry = commandRegistry;
        this.lineParser = new LineParser();
    }

    @Override
    public CommandRegistry<CI> getRegistry() {
        return this.registry;
    }

    @Override
    public CommandContainer<CI> resolveCommand(String line) throws CommandNotFoundException {
        return this.getCommand(this.lineParser.parseLine(line), line);
    }

    @Override
    public CommandContainer<CI> resolveCommand(ParsedLine line) throws CommandNotFoundException {
        return this.getCommand(line, line.line());
    }

    @Override
    public CommandContainer<CI> resolveCommand(String name, String line) throws CommandNotFoundException {
        return this.getCommand(name, line);
    }

    private CommandContainer<CI> getCommand(ParsedLine aeshLine, String line) throws CommandNotFoundException {
        return this.getCommand(aeshLine.words().get(0).word(), line);
    }

    private CommandContainer<CI> getCommand(String commandName, String line) throws CommandNotFoundException {
        try {
            return this.registry.getCommand(commandName, line);
        }
        catch (CommandNotFoundException e) {
            return this.registry.getCommandByAlias(commandName);
        }
    }
}

