/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.result.NullResultHandler;
import org.aesh.command.impl.validator.NullCommandValidator;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.map.MapCommand;
import org.aesh.command.map.MapCommandPopulator;
import org.aesh.command.map.MapProcessedCommand;
import org.aesh.command.map.MapProcessedOptionProvider;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.populator.CommandPopulator;
import org.aesh.command.result.ResultHandler;
import org.aesh.command.validator.CommandValidator;
import org.aesh.util.ReflectionUtil;

public class MapProcessedCommandBuilder<CI extends CommandInvocation> {
    private MapProcessedOptionProvider provider;
    private String name;
    private String description;
    private CommandValidator<MapCommand<CI>, CI> validator;
    private ResultHandler resultHandler;
    private ProcessedOption arguments;
    private ProcessedOption argument;
    private final List<ProcessedOption> options = new ArrayList<ProcessedOption>();
    private CommandPopulator<Object, CI> populator;
    private MapCommand<CI> command;
    private List<String> aliases;
    private CommandActivator activator;
    private boolean lookup;

    private MapProcessedCommandBuilder() {
    }

    public static <T extends CommandInvocation> MapProcessedCommandBuilder<T> builder() {
        return new MapProcessedCommandBuilder();
    }

    public MapProcessedCommandBuilder<CI> lookupAtCompletionOnly(boolean lookup) {
        this.lookup = lookup;
        return this;
    }

    public MapProcessedCommandBuilder<CI> name(String name) {
        this.name = name;
        return this;
    }

    public MapProcessedCommandBuilder<CI> name(List<String> aliases) {
        this.aliases = aliases == null ? Collections.emptyList() : Collections.unmodifiableList(aliases);
        return this;
    }

    public MapProcessedCommandBuilder<CI> description(String usage) {
        this.description = usage;
        return this;
    }

    public MapProcessedCommandBuilder<CI> optionProvider(MapProcessedOptionProvider provider) {
        this.provider = provider;
        return this;
    }

    public MapProcessedCommandBuilder<CI> arguments(ProcessedOption arguments) {
        this.arguments = arguments;
        return this;
    }

    public MapProcessedCommandBuilder<CI> argument(ProcessedOption argument) {
        this.argument = argument;
        return this;
    }

    public MapProcessedCommandBuilder<CI> validator(CommandValidator<MapCommand<CI>, CI> validator) {
        this.validator = validator;
        return this;
    }

    public MapProcessedCommandBuilder<CI> validator(Class<? extends CommandValidator> validator) {
        this.validator = this.initValidator(validator);
        return this;
    }

    private CommandValidator initValidator(Class<? extends CommandValidator> validator) {
        if (validator != null && !validator.equals(NullCommandValidator.class)) {
            return ReflectionUtil.newInstance(validator);
        }
        return new NullCommandValidator();
    }

    public MapProcessedCommandBuilder<CI> resultHandler(Class<? extends ResultHandler> resultHandler) {
        this.resultHandler = this.initResultHandler(resultHandler);
        return this;
    }

    private ResultHandler initResultHandler(Class<? extends ResultHandler> resultHandler) {
        if (resultHandler != null && !resultHandler.equals(NullResultHandler.class)) {
            return ReflectionUtil.newInstance(resultHandler);
        }
        return new NullResultHandler();
    }

    public MapProcessedCommandBuilder<CI> resultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
        return this;
    }

    public MapProcessedCommandBuilder<CI> populator(CommandPopulator<Object, CI> populator) {
        this.populator = populator;
        return this;
    }

    public MapProcessedCommandBuilder<CI> command(MapCommand<CI> command) {
        this.command = command;
        return this;
    }

    public MapProcessedCommandBuilder<CI> command(Class<? extends MapCommand<CI>> command) {
        this.command = ReflectionUtil.newInstance(command);
        return this;
    }

    public MapProcessedCommandBuilder<CI> addOption(ProcessedOption option) {
        this.options.add(option);
        return this;
    }

    public MapProcessedCommandBuilder<CI> addOptions(List<ProcessedOption> options) {
        if (options != null) {
            this.options.addAll(options);
        }
        return this;
    }

    public MapProcessedCommandBuilder<CI> activator(CommandActivator activator) {
        this.activator = activator;
        return this;
    }

    public MapProcessedCommand<CI> create() throws CommandLineParserException {
        if (this.name == null || this.name.length() < 1) {
            throw new CommandLineParserException("The parameter name must be defined");
        }
        if (this.validator == null) {
            this.validator = new NullCommandValidator();
        }
        if (this.resultHandler == null) {
            this.resultHandler = new NullResultHandler();
        }
        if (this.populator == null) {
            this.populator = new MapCommandPopulator<Object, CI>(this.command);
        }
        return new MapProcessedCommand<CI>(this.name, this.aliases, this.command, this.description, this.validator, this.resultHandler, this.arguments, this.options, this.argument, this.populator, this.provider, this.activator, this.lookup);
    }
}

