/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.universe.UniverseFactoryLoader;

@CommandDefinition(name="add-universe", description="Add a universe to the provisioning state. Called without a universe name, set the default universe of this installation")
public class StateAddUniverseCommand
extends PmSessionCommand {
    @Option(completer=UniverseFactoryCompleter.class, required=true, description="Universe factory name")
    protected String factory;
    @Option(required=false, description="Universe name")
    protected String name;
    @Option(required=true, description="Universe location")
    protected String location;

    @Override
    protected void runCommand(PmCommandInvocation commandInvocation) throws CommandExecutionException {
        try {
            commandInvocation.getPmSession().getUniverse().addUniverse(this.name, this.factory, this.location);
        }
        catch (IOException | ProvisioningException ex) {
            throw new CommandExecutionException(commandInvocation.getPmSession(), CliErrors.addUniverseFailed(), ex);
        }
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.EDITING;
    }

    public static class UniverseFactoryCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(UniverseFactoryLoader.getInstance().getFactories());
            return names;
        }
    }
}

