/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.gradle.api.internal.changedetection.state.FallbackHandlingResourceHasher;
import org.gradle.api.internal.changedetection.state.LineEndingNormalizingInputStreamHasher;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.io.IoFunction;

public class LineEndingNormalizingResourceHasher
extends FallbackHandlingResourceHasher {
    private final LineEndingNormalizingInputStreamHasher hasher = new LineEndingNormalizingInputStreamHasher();

    private LineEndingNormalizingResourceHasher(ResourceHasher delegate) {
        super(delegate);
    }

    public static ResourceHasher wrap(ResourceHasher delegate, LineEndingSensitivity lineEndingSensitivity) {
        switch (lineEndingSensitivity) {
            case DEFAULT: {
                return delegate;
            }
            case NORMALIZE_LINE_ENDINGS: {
                return new LineEndingNormalizingResourceHasher(delegate);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    boolean filter(RegularFileSnapshotContext context) {
        return true;
    }

    @Override
    boolean filter(ZipEntryContext context) {
        return !context.getEntry().isDirectory();
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        super.appendConfigurationToHasher(hasher);
        hasher.putString((CharSequence)this.getClass().getName());
    }

    @Override
    Optional<HashCode> tryHash(RegularFileSnapshotContext snapshotContext) {
        return Optional.of(snapshotContext).flatMap(IoFunction.wrap(this::hashContent));
    }

    @Override
    Optional<HashCode> tryHash(ZipEntryContext zipEntryContext) {
        return Optional.of(zipEntryContext).flatMap(IoFunction.wrap(this::hashContent));
    }

    private Optional<HashCode> hashContent(RegularFileSnapshotContext snapshotContext) throws IOException {
        return this.hasher.hashContent(new File(snapshotContext.getSnapshot().getAbsolutePath()));
    }

    private Optional<HashCode> hashContent(ZipEntryContext zipEntryContext) throws IOException {
        return (Optional)zipEntryContext.getEntry().withInputStream(this.hasher::hashContent);
    }
}

