/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.datagram;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.SHA256Generator;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.util.Log;
import net.i2p.util.SimpleByteCache;

public final class I2PDatagramMaker {
    private static final int DGRAM_BUFSIZE = 32768;
    private final SHA256Generator hashGen = SHA256Generator.getInstance();
    private final DSAEngine dsaEng = DSAEngine.getInstance();
    private SigningPrivateKey sxPrivKey;
    private byte[] sxDestBytes;
    private final ByteArrayOutputStream sxDGram = new ByteArrayOutputStream(32768);

    public I2PDatagramMaker(I2PSession session) {
        this.setI2PDatagramMaker(session);
    }

    public I2PDatagramMaker() {
    }

    public void setI2PDatagramMaker(I2PSession session) {
        if (session.isOffline()) {
            throw new IllegalArgumentException("Offline keys unsupported");
        }
        this.sxPrivKey = session.getPrivateKey();
        this.sxDestBytes = session.getMyDestination().toByteArray();
    }

    public byte[] makeI2PDatagram(byte[] payload) {
        this.sxDGram.reset();
        try {
            Signature sig;
            this.sxDGram.write(this.sxDestBytes);
            SigType type = this.sxPrivKey.getType();
            if (type == null) {
                throw new IllegalStateException("Unsupported sig type");
            }
            if (type == SigType.DSA_SHA1) {
                byte[] hash = SimpleByteCache.acquire(32);
                this.hashGen.calculateHash(payload, 0, payload.length, hash, 0);
                sig = this.dsaEng.sign(hash, this.sxPrivKey);
                SimpleByteCache.release(hash);
            } else {
                sig = this.dsaEng.sign(payload, this.sxPrivKey);
            }
            sig.writeBytes(this.sxDGram);
            this.sxDGram.write(payload);
            if (this.sxDGram.size() > 32768) {
                throw new IllegalArgumentException("Too big");
            }
            return this.sxDGram.toByteArray();
        }
        catch (IOException e) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(I2PDatagramMaker.class);
            log.error("Caught IOException", e);
            return null;
        }
        catch (DataFormatException e) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(I2PDatagramMaker.class);
            log.error("Caught DataFormatException", e);
            return null;
        }
    }
}

