/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.DynamicBundle;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageOptions;
import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class CoverageOptionsConfigurable
extends CompositeConfigurable<CoverageOptions>
implements SearchableConfigurable,
Configurable.WithEpDependencies {
    private CoverageOptionsPanel myPanel;
    private final CoverageOptionsProvider myManager;
    private final Project myProject;

    public CoverageOptionsConfigurable(Project project2) {
        this.myManager = CoverageOptionsProvider.getInstance(project2);
        this.myProject = project2;
    }

    @NotNull
    public String getId() {
        return "coverage";
    }

    @Nls
    public String getDisplayName() {
        return CoverageBundle.message("configurable.CoverageOptionsConfigurable.display.name", new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.project.settings.coverage";
    }

    public JComponent createComponent() {
        this.myPanel = new CoverageOptionsPanel();
        List<JComponent> extensionPanels = this.collectExtensionOptionsComponents();
        if (extensionPanels.size() > 0) {
            return this.createCompositePanel(extensionPanels);
        }
        return this.myPanel.myWholePanel;
    }

    private List<JComponent> collectExtensionOptionsComponents() {
        ArrayList<JComponent> additionalPanels = new ArrayList<JComponent>();
        for (CoverageOptions coverageOptions : this.getConfigurables()) {
            additionalPanels.add(coverageOptions.createComponent());
        }
        return additionalPanels;
    }

    private JComponent createCompositePanel(List<JComponent> additionalPanels) {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 1.0;
        c.fill = 2;
        panel2.add((Component)this.myPanel.myWholePanel, c);
        for (JComponent p : additionalPanels) {
            panel2.add((Component)p, c);
        }
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel2.add((Component)Box.createVerticalBox(), c);
        return panel2;
    }

    @NotNull
    protected List<CoverageOptions> createConfigurables() {
        List list = CoverageOptions.EP_NAME.getExtensions((AreaInstance)this.myProject);
        if (list == null) {
            CoverageOptionsConfigurable.$$$reportNull$$$0(0);
        }
        return list;
    }

    public boolean isModified() {
        if (this.myManager.getOptionToReplace() != this.getSelectedValue()) {
            return true;
        }
        if (this.myManager.activateViewOnRun() != this.myPanel.myActivateCoverageViewCB.isSelected()) {
            return true;
        }
        return super.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myManager.setOptionsToReplace(this.getSelectedValue());
        this.myManager.setActivateViewOnRun(this.myPanel.myActivateCoverageViewCB.isSelected());
        super.apply();
    }

    private int getSelectedValue() {
        if (this.myPanel.myReplaceRB.isSelected()) {
            return 0;
        }
        if (this.myPanel.myAddRB.isSelected()) {
            return 1;
        }
        if (this.myPanel.myDoNotApplyRB.isSelected()) {
            return 2;
        }
        return 3;
    }

    public void reset() {
        int addOrReplace = this.myManager.getOptionToReplace();
        JRadioButton radioButton = switch (addOrReplace) {
            case 0 -> this.myPanel.myReplaceRB;
            case 1 -> this.myPanel.myAddRB;
            case 2 -> this.myPanel.myDoNotApplyRB;
            default -> this.myPanel.myShowOptionsRB;
        };
        radioButton.setSelected(true);
        this.myPanel.myActivateCoverageViewCB.setSelected(this.myManager.activateViewOnRun());
        super.reset();
    }

    public void disposeUIResources() {
        this.myPanel = null;
        super.disposeUIResources();
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        List<ProjectExtensionPointName<CoverageOptions>> list = Collections.singletonList(CoverageOptions.EP_NAME);
        if (list == null) {
            CoverageOptionsConfigurable.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/coverage/CoverageOptionsConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CoverageOptionsPanel {
        private JRadioButton myShowOptionsRB;
        private JRadioButton myReplaceRB;
        private JRadioButton myAddRB;
        private JRadioButton myDoNotApplyRB;
        private JPanel myWholePanel;
        private JCheckBox myActivateCoverageViewCB;

        private CoverageOptionsPanel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JRadioButton jRadioButton;
            JRadioButton jRadioButton2;
            JRadioButton jRadioButton3;
            JRadioButton jRadioButton4;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
            jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/CoverageBundle", CoverageOptionsPanel.class).getString("settings.coverage.when.new.coverage.is.gathered"), (int)0, (int)0, null, null));
            this.myShowOptionsRB = jRadioButton4 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton4, DynamicBundle.getBundle((String)"messages/CoverageBundle", CoverageOptionsPanel.class).getString("settings.coverage.show.options.before.applying.coverage.to.the.editor"));
            jPanel2.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myReplaceRB = jRadioButton3 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/CoverageBundle", CoverageOptionsPanel.class).getString("settings.coverage.replace.active.suites.with.the.new.one"));
            jPanel2.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAddRB = jRadioButton2 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/CoverageBundle", CoverageOptionsPanel.class).getString("settings.coverage.add.to.the.active.suites"));
            jPanel2.add((Component)jRadioButton2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDoNotApplyRB = jRadioButton = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/CoverageBundle", CoverageOptionsPanel.class).getString("settings.coverage.do.not.apply.collected.coverage"));
            jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myActivateCoverageViewCB = jCheckBox = new JCheckBox();
            jCheckBox.setMargin(new Insets(8, 3, 2, 3));
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/CoverageBundle", CoverageOptionsPanel.class).getString("settings.coverage.activate.coverage.view"));
            jPanel2.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton4);
            buttonGroup.add(jRadioButton3);
            buttonGroup.add(jRadioButton2);
            buttonGroup.add(jRadioButton);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string2.length(); ++i) {
                if (string2.charAt(i) == '&') {
                    if (++i == string2.length()) break;
                    if (!bl && string2.charAt(i) != '&') {
                        bl = true;
                        c = string2.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string2.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

