/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ui.ColumnInfo;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoverageViewExtension {
    protected final Project myProject;
    protected final CoverageSuitesBundle mySuitesBundle;
    protected final CoverageViewManager.StateBean myStateBean;
    protected final CoverageDataManager myCoverageDataManager;
    protected final CoverageViewManager myCoverageViewManager;

    public CoverageViewExtension(@NotNull Project project2, CoverageSuitesBundle suitesBundle, CoverageViewManager.StateBean stateBean) {
        if (project2 == null) {
            CoverageViewExtension.$$$reportNull$$$0(0);
        }
        assert (!project2.isDefault()) : "Should not run coverage for default project";
        this.myProject = project2;
        this.mySuitesBundle = suitesBundle;
        this.myStateBean = stateBean;
        this.myCoverageDataManager = CoverageDataManager.getInstance(this.myProject);
        this.myCoverageViewManager = CoverageViewManager.getInstance(this.myProject);
    }

    @Deprecated
    @Nullable
    @Nls
    public abstract String getSummaryForNode(@NotNull AbstractTreeNode<?> var1);

    @Deprecated
    @Nullable
    @Nls
    public abstract String getSummaryForRootNode(@NotNull AbstractTreeNode<?> var1);

    @Nullable
    public abstract String getPercentage(int var1, @NotNull AbstractTreeNode<?> var2);

    public abstract List<AbstractTreeNode<?>> getChildrenNodes(AbstractTreeNode<?> var1);

    public abstract ColumnInfo[] createColumnInfos();

    @Nullable
    public abstract PsiElement getParentElement(PsiElement var1);

    @NotNull
    public abstract AbstractTreeNode<?> createRootNode();

    public boolean canSelectInCoverageView(Object object) {
        return object instanceof VirtualFile && PsiManager.getInstance((Project)this.myProject).findFile((VirtualFile)object) != null;
    }

    @Nullable
    public PsiElement getElementToSelect(Object object) {
        if (object instanceof PsiElement) {
            return (PsiElement)object;
        }
        return object instanceof VirtualFile ? PsiManager.getInstance((Project)this.myProject).findFile((VirtualFile)object) : null;
    }

    @Nullable
    public VirtualFile getVirtualFile(Object object) {
        if (object instanceof PsiElement) {
            if (object instanceof PsiDirectory) {
                return ((PsiDirectory)object).getVirtualFile();
            }
            PsiFile containingFile = ((PsiElement)object).getContainingFile();
            if (containingFile != null) {
                return containingFile.getVirtualFile();
            }
            return null;
        }
        return object instanceof VirtualFile ? (VirtualFile)object : null;
    }

    @NotNull
    public List<AbstractTreeNode<?>> createTopLevelNodes() {
        List<AbstractTreeNode<?>> list = Collections.emptyList();
        if (list == null) {
            CoverageViewExtension.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean supportFlattenPackages() {
        return false;
    }

    @ApiStatus.Experimental
    @NotNull
    public List<AnAction> createExtraToolbarActions() {
        List<AnAction> list = Collections.emptyList();
        if (list == null) {
            CoverageViewExtension.$$$reportNull$$$0(2);
        }
        return list;
    }

    public String getElementsName() {
        return CoverageBundle.message("coverage.files", new Object[0]);
    }

    public String getElementsCapitalisedName() {
        return CoverageBundle.message("coverage.files.capitalised", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/view/CoverageViewExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/view/CoverageViewExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopLevelNodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtraToolbarActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }
}

