/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.dvcs.repo.ClonePathProvider;
import com.intellij.dvcs.ui.CloneDvcsValidationUtils;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboBoxCompositeEditor;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.progress.ComponentVisibilityProgressManager;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
public abstract class CloneDvcsDialog
extends DialogWrapper {
    private ComboBox<String> myRepositoryUrlCombobox;
    private CollectionComboBoxModel<String> myRepositoryUrlComboboxModel;
    private TextFieldWithAutoCompletion<String> myRepositoryUrlField;
    private ComponentVisibilityProgressManager mySpinnerProgressManager;
    private JButton myTestButton;
    private MyTextFieldWithBrowseButton myDirectoryField;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final String myVcsDirectoryName;
    @Nullable
    private ValidationInfo myCreateDirectoryValidationInfo;
    @Nullable
    private ValidationInfo myRepositoryTestValidationInfo;
    @Nullable
    private ProgressIndicator myRepositoryTestProgressIndicator;

    public CloneDvcsDialog(@NotNull Project project2, @NotNull @Nls String displayName, @NotNull String vcsDirectoryName) {
        if (project2 == null) {
            CloneDvcsDialog.$$$reportNull$$$0(0);
        }
        if (displayName == null) {
            CloneDvcsDialog.$$$reportNull$$$0(1);
        }
        if (vcsDirectoryName == null) {
            CloneDvcsDialog.$$$reportNull$$$0(2);
        }
        this(project2, displayName, vcsDirectoryName, null);
    }

    public CloneDvcsDialog(@NotNull Project project2, @NotNull @Nls String displayName, @NotNull String vcsDirectoryName, @Nullable String defaultUrl) {
        if (project2 == null) {
            CloneDvcsDialog.$$$reportNull$$$0(3);
        }
        if (displayName == null) {
            CloneDvcsDialog.$$$reportNull$$$0(4);
        }
        if (vcsDirectoryName == null) {
            CloneDvcsDialog.$$$reportNull$$$0(5);
        }
        super(project2, true);
        this.myProject = project2;
        this.myVcsDirectoryName = vcsDirectoryName;
        this.initComponents(defaultUrl);
        this.setTitle(DvcsBundle.message("clone.title", new Object[0]));
        this.setOKButtonText(DvcsBundle.message("clone.button", new Object[0]));
        this.init();
    }

    protected void doOKAction() {
        final String path2 = this.myDirectoryField.getText();
        new Task.Modal(this.myProject, DvcsBundle.message("progress.title.creating.destination.directory", new Object[0]), true){
            private ValidationInfo error;
            {
                super(arg0, arg1, arg2);
                this.error = null;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.error = CloneDvcsValidationUtils.createDestination(path2);
            }

            public void onSuccess() {
                if (this.error == null) {
                    CloneDvcsDialog.super.doOKAction();
                } else {
                    CloneDvcsDialog.this.myCreateDirectoryValidationInfo = this.error;
                    CloneDvcsDialog.this.startTrackingValidation();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/ui/CloneDvcsDialog$1", "run"));
            }
        }.queue();
    }

    @NotNull
    public String getSourceRepositoryURL() {
        return this.getCurrentUrlText();
    }

    @NotNull
    public String getParentDirectory() {
        Path parent = Paths.get(this.myDirectoryField.getText(), new String[0]).toAbsolutePath().getParent();
        String string2 = Objects.requireNonNull(parent).toAbsolutePath().toString();
        if (string2 == null) {
            CloneDvcsDialog.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @NotNull
    public String getDirectoryName() {
        String string2 = Paths.get(this.myDirectoryField.getText(), new String[0]).getFileName().toString();
        if (string2 == null) {
            CloneDvcsDialog.$$$reportNull$$$0(7);
        }
        return string2;
    }

    private void initComponents(@Nullable String defaultUrl) {
        this.myRepositoryUrlComboboxModel = new CollectionComboBoxModel();
        this.myRepositoryUrlField = TextFieldWithAutoCompletion.create((Project)this.myProject, (Collection)this.myRepositoryUrlComboboxModel.getItems(), (boolean)false, (String)"");
        JLabel repositoryUrlFieldSpinner = new JLabel((Icon)new AnimatedIcon.Default());
        repositoryUrlFieldSpinner.setVisible(false);
        this.mySpinnerProgressManager = new ComponentVisibilityProgressManager(repositoryUrlFieldSpinner);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.mySpinnerProgressManager);
        this.myRepositoryUrlCombobox = new ComboBox();
        this.myRepositoryUrlCombobox.setEditable(true);
        this.myRepositoryUrlCombobox.setEditor((ComboBoxEditor)ComboBoxCompositeEditor.withComponents(this.myRepositoryUrlField, (JComponent[])new JComponent[]{repositoryUrlFieldSpinner}));
        this.myRepositoryUrlCombobox.setModel(this.myRepositoryUrlComboboxModel);
        this.myRepositoryUrlField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                CloneDvcsDialog.this.myDirectoryField.trySetChildPath(CloneDvcsDialog.this.defaultDirectoryPath(CloneDvcsDialog.this.myRepositoryUrlField.getText().trim()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/dvcs/ui/CloneDvcsDialog$2", "documentChanged"));
            }
        });
        this.myRepositoryUrlField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                CloneDvcsDialog.this.myRepositoryTestValidationInfo = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/dvcs/ui/CloneDvcsDialog$3", "documentChanged"));
            }
        });
        this.myTestButton = new JButton(DvcsBundle.message("clone.repository.url.test.label", new Object[0]));
        this.myTestButton.addActionListener(e -> this.test());
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setHideIgnored(false);
        this.myDirectoryField = new MyTextFieldWithBrowseButton(ClonePathProvider.defaultParentDirectoryPath(this.myProject, this.getRememberedInputs()));
        this.myDirectoryField.addBrowseFolderListener(DvcsBundle.message("clone.destination.directory.browser.title", new Object[0]), DvcsBundle.message("clone.destination.directory.browser.description", new Object[0]), this.myProject, fcd);
        if (defaultUrl != null) {
            this.myRepositoryUrlField.setText(defaultUrl);
            this.myRepositoryUrlField.selectAll();
            this.myTestButton.setEnabled(true);
        }
    }

    private void test() {
        final String testUrl = this.getCurrentUrlText();
        if (this.myRepositoryTestProgressIndicator != null) {
            this.myRepositoryTestProgressIndicator.cancel();
            this.myRepositoryTestProgressIndicator = null;
        }
        this.myRepositoryTestProgressIndicator = this.mySpinnerProgressManager.run(new Task.Backgroundable(this.myProject, DvcsBundle.message("clone.repository.url.test.title", testUrl), true){
            private TestResult myTestResult;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                this.myTestResult = CloneDvcsDialog.this.test(testUrl);
            }

            public void onSuccess() {
                if (this.myTestResult.isSuccess()) {
                    CloneDvcsDialog.this.myRepositoryTestValidationInfo = null;
                    Disposable dialogDisposable = CloneDvcsDialog.this.getDisposable();
                    if (Disposer.isDisposed((Disposable)dialogDisposable)) {
                        return;
                    }
                    JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(DvcsBundle.message("clone.repository.url.test.success.message", new Object[0]))).setDisposable(dialogDisposable).createBalloon().show(new RelativePoint((Component)CloneDvcsDialog.this.myTestButton, new Point(CloneDvcsDialog.this.myTestButton.getWidth() / 2, CloneDvcsDialog.this.myTestButton.getHeight())), Balloon.Position.below);
                } else {
                    CloneDvcsDialog.this.myRepositoryTestValidationInfo = new ValidationInfo(DvcsBundle.message("clone.repository.url.test.failed.message", XmlStringUtil.escapeString((String)this.myTestResult.myErrorMessage)), CloneDvcsDialog.this.myRepositoryUrlCombobox);
                    CloneDvcsDialog.this.startTrackingValidation();
                }
                CloneDvcsDialog.this.myRepositoryTestProgressIndicator = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/ui/CloneDvcsDialog$4", "run"));
            }
        });
    }

    @NotNull
    protected abstract TestResult test(@NotNull String var1);

    @NotNull
    protected abstract DvcsRememberedInputs getRememberedInputs();

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        ValidationInfo urlValidation = CloneDvcsValidationUtils.checkRepositoryURL(this.myRepositoryUrlCombobox, this.getCurrentUrlText());
        ValidationInfo directoryValidation = CloneDvcsValidationUtils.checkDirectory(this.myDirectoryField.getText(), this.myDirectoryField.getTextField());
        this.myTestButton.setEnabled(urlValidation == null);
        ArrayList<ValidationInfo> infoList = new ArrayList<ValidationInfo>();
        ContainerUtil.addIfNotNull(infoList, (Object)this.myRepositoryTestValidationInfo);
        ContainerUtil.addIfNotNull(infoList, (Object)this.myCreateDirectoryValidationInfo);
        ContainerUtil.addIfNotNull(infoList, (Object)urlValidation);
        ContainerUtil.addIfNotNull(infoList, (Object)directoryValidation);
        ArrayList<ValidationInfo> arrayList = infoList;
        if (arrayList == null) {
            CloneDvcsDialog.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private String getCurrentUrlText() {
        String string2 = FileUtil.expandUserHome((String)this.myRepositoryUrlField.getText().trim());
        if (string2 == null) {
            CloneDvcsDialog.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @Deprecated(forRemoval=true)
    public void prependToHistory(@NotNull String item2) {
        if (item2 == null) {
            CloneDvcsDialog.$$$reportNull$$$0(10);
        }
        this.myRepositoryUrlComboboxModel.add((Object)item2);
    }

    public void rememberSettings() {
        DvcsRememberedInputs rememberedInputs = this.getRememberedInputs();
        rememberedInputs.addUrl(this.getSourceRepositoryURL());
        rememberedInputs.setCloneParentDir(this.getParentDirectory());
    }

    @NotNull
    private String defaultDirectoryPath(@NotNull String url) {
        if (url == null) {
            CloneDvcsDialog.$$$reportNull$$$0(11);
        }
        String string2 = StringUtil.trimEnd((String)ClonePathProvider.relativeDirectoryPathForVcsUrl(this.myProject, url), (String)this.myVcsDirectoryName);
        if (string2 == null) {
            CloneDvcsDialog.$$$reportNull$$$0(12);
        }
        return string2;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myRepositoryUrlField;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)JBUI.Panels.simplePanel((int)10, (int)4).addToCenter(this.myRepositoryUrlCombobox).addToRight((Component)this.myTestButton)).withLabel(DvcsBundle.message("clone.repository.url.label", new Object[0]))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)((Object)this.myDirectoryField)).withLabel(DvcsBundle.message("clone.destination.directory.label", new Object[0]))).createPanel();
        panel2.setPreferredSize((Dimension)new JBDimension(500, 50, true));
        JPanel jPanel = panel2;
        if (jPanel == null) {
            CloneDvcsDialog.$$$reportNull$$$0(13);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsDirectoryName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/ui/CloneDvcsDialog";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/ui/CloneDvcsDialog";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentUrlText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultDirectoryPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prependToHistory";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "defaultDirectoryPath";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7, 8, 9, 12, 13 -> new IllegalStateException(string2);
        };
    }

    private static final class MyTextFieldWithBrowseButton
    extends TextFieldWithBrowseButton {
        @NotNull
        private final Path myDefaultParentPath;
        private boolean myModifiedByUser;

        private MyTextFieldWithBrowseButton(@NotNull @NonNls String defaultParentPath) {
            if (defaultParentPath == null) {
                MyTextFieldWithBrowseButton.$$$reportNull$$$0(0);
            }
            this.myModifiedByUser = false;
            this.myDefaultParentPath = Paths.get(defaultParentPath, new String[0]).toAbsolutePath();
            this.setText(this.myDefaultParentPath.toString());
            this.getTextField().getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    myModifiedByUser = true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/ui/CloneDvcsDialog$MyTextFieldWithBrowseButton$1", "textChanged"));
                }
            });
        }

        public void trySetChildPath(@NotNull String child) {
            if (child == null) {
                MyTextFieldWithBrowseButton.$$$reportNull$$$0(1);
            }
            if (!this.myModifiedByUser) {
                try {
                    this.setText(this.myDefaultParentPath.resolve(child).toString());
                }
                catch (InvalidPathException invalidPathException) {
                }
                finally {
                    this.myModifiedByUser = false;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultParentPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dvcs/ui/CloneDvcsDialog$MyTextFieldWithBrowseButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "trySetChildPath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class TestResult {
        @NotNull
        public static final TestResult SUCCESS = new TestResult(null);
        @Nullable
        private final String myErrorMessage;

        public TestResult(@Nullable String errorMessage) {
            this.myErrorMessage = errorMessage;
        }

        public boolean isSuccess() {
            return this.myErrorMessage == null;
        }

        @Nullable
        public String getError() {
            return this.myErrorMessage;
        }
    }
}

