/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.RevisionsCollector;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.history.integration.ui.models.RevisionItem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HistoryDialogModel {
    protected final Project myProject;
    protected LocalHistoryFacade myVcs;
    protected VirtualFile myFile;
    protected IdeaGateway myGateway;
    private String myFilter;
    private List<RevisionItem> myRevisionsCache;
    private Revision myCurrentRevisionCache;
    private int myRightRevisionIndex;
    private int myLeftRevisionIndex;
    private Entry[] myLeftEntryCache;
    private Entry[] myRightEntryCache;

    public HistoryDialogModel(Project p, IdeaGateway gw, LocalHistoryFacade vcs, VirtualFile f) {
        this.myProject = p;
        this.myVcs = vcs;
        this.myFile = f;
        this.myGateway = gw;
    }

    @NlsContexts.DialogTitle
    public String getTitle() {
        return FileUtil.toSystemDependentName((String)this.myFile.getPath());
    }

    public List<RevisionItem> getRevisions() {
        if (this.myRevisionsCache == null) {
            Pair<Revision, List<RevisionItem>> revs = this.calcRevisionsCache();
            this.myCurrentRevisionCache = (Revision)revs.first;
            this.myRevisionsCache = (List)revs.second;
        }
        return this.myRevisionsCache;
    }

    public Revision getCurrentRevision() {
        this.getRevisions();
        return this.myCurrentRevisionCache;
    }

    protected Pair<Revision, List<RevisionItem>> calcRevisionsCache() {
        return (Pair)ReadAction.compute(() -> {
            this.myGateway.registerUnsavedDocuments(this.myVcs);
            String path2 = this.myGateway.getPathOrUrl(this.myFile);
            RootEntry root = this.myGateway.createTransientRootEntry();
            RevisionsCollector collector = new RevisionsCollector(this.myVcs, root, path2, this.myProject.getLocationHash(), this.myFilter);
            List<Revision> all2 = collector.getResult();
            return Pair.create((Object)all2.get(0), HistoryDialogModel.groupRevisions(all2.subList(1, all2.size())));
        });
    }

    public void processContents(final @NotNull PairProcessor<? super Revision, ? super String> processor2) {
        if (processor2 == null) {
            HistoryDialogModel.$$$reportNull$$$0(0);
        }
        final HashMap<Long, Revision> revMap = new HashMap<Long, Revision>();
        for (RevisionItem r : this.getRevisions()) {
            revMap.put(r.revision.getChangeSetId(), r.revision);
        }
        if (revMap.isEmpty()) {
            return;
        }
        this.myVcs.accept(new ChangeVisitor(){
            final RootEntry root;
            String path;
            {
                this.root = ((Revision)ContainerUtil.getFirstItem(revMap.values())).getRoot().copy();
                this.path = HistoryDialogModel.this.myGateway.getPathOrUrl(HistoryDialogModel.this.myFile);
                this.processContent((Revision)revMap.get(null));
            }

            private boolean processContent(@Nullable Revision revision) {
                if (revision == null) {
                    return true;
                }
                Entry entry2 = this.root.findEntry(this.path);
                Content content = entry2 == null ? null : entry2.getContent();
                String text2 = content == null ? null : content.getString(entry2, HistoryDialogModel.this.myGateway);
                return processor2.process((Object)revision, (Object)text2);
            }

            @Override
            public void begin(ChangeSet c) {
                ProgressManager.checkCanceled();
                if (Thread.currentThread().isInterrupted()) {
                    throw new ProcessCanceledException();
                }
            }

            @Override
            public void end(ChangeSet c) throws ChangeVisitor.StopVisitingException {
                if (!this.processContent((Revision)revMap.get(c.getId()))) {
                    this.stop();
                }
            }

            @Override
            public void visit(StructuralChange c) {
                if (c.affectsPath(this.path)) {
                    c.revertOn(this.root, false);
                    this.path = c.revertPath(this.path);
                }
            }
        });
    }

    private static List<RevisionItem> groupRevisions(List<? extends Revision> revs) {
        LinkedList<RevisionItem> result2 = new LinkedList<RevisionItem>();
        for (Revision each : ContainerUtil.iterateBackward(revs)) {
            if (each.isLabel() && !result2.isEmpty()) {
                result2.getFirst().labels.addFirst(each);
                continue;
            }
            result2.addFirst(new RevisionItem(each));
        }
        return result2;
    }

    public void setFilter(@Nullable String filter2) {
        this.myFilter = StringUtil.isEmptyOrSpaces((String)filter2) ? null : filter2;
        this.clearRevisions();
    }

    public void clearRevisions() {
        this.myRevisionsCache = null;
        this.resetEntriesCache();
    }

    private void resetEntriesCache() {
        this.myLeftEntryCache = null;
        this.myRightEntryCache = null;
    }

    public Revision getLeftRevision() {
        if (this.getRevisions().isEmpty()) {
            return this.getCurrentRevision();
        }
        return this.getRevisions().get((int)this.myLeftRevisionIndex).revision;
    }

    public Revision getRightRevision() {
        if (this.isCurrentRevisionSelected() || this.getRevisions().isEmpty()) {
            return this.getCurrentRevision();
        }
        return this.getRevisions().get((int)this.myRightRevisionIndex).revision;
    }

    protected Entry getLeftEntry() {
        if (this.myLeftEntryCache == null) {
            this.myLeftEntryCache = new Entry[]{this.getLeftRevision().findEntry()};
        }
        return this.myLeftEntryCache[0];
    }

    protected Entry getRightEntry() {
        if (this.myRightEntryCache == null) {
            this.myRightEntryCache = new Entry[]{this.getRightRevision().findEntry()};
        }
        return this.myRightEntryCache[0];
    }

    public boolean selectRevisions(int first, int second) {
        int l;
        int r;
        if (first == second) {
            r = -1;
            l = first == -1 ? 0 : first;
        } else {
            r = first;
            l = second;
        }
        if (this.myRightRevisionIndex == r && this.myLeftRevisionIndex == l) {
            return false;
        }
        this.myRightRevisionIndex = r;
        this.myLeftRevisionIndex = l;
        this.resetEntriesCache();
        return true;
    }

    public boolean resetSelection() {
        return this.selectRevisions(0, 0);
    }

    public boolean isCurrentRevisionSelected() {
        return this.myRightRevisionIndex == -1;
    }

    public List<Change> getChanges() {
        List<Difference> dd = this.getDifferences();
        ArrayList<Change> result2 = new ArrayList<Change>();
        for (Difference d : dd) {
            result2.add(this.createChange(d));
        }
        return result2;
    }

    protected List<Difference> getDifferences() {
        return this.getLeftRevision().getDifferencesWith(this.getRightRevision());
    }

    protected Change createChange(Difference d) {
        return new Change(d.getLeftContentRevision(this.myGateway), d.getRightContentRevision(this.myGateway));
    }

    public abstract Reverter createReverter();

    public boolean isRevertEnabled() {
        return this.isCorrectSelectionForRevertAndPatch();
    }

    public boolean isCreatePatchEnabled() {
        return this.isCorrectSelectionForRevertAndPatch();
    }

    private boolean isCorrectSelectionForRevertAndPatch() {
        return this.myLeftRevisionIndex != -1;
    }

    public boolean canPerformCreatePatch() {
        return !this.getLeftEntry().hasUnavailableContent() && !this.getRightEntry().hasUnavailableContent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/history/integration/ui/models/HistoryDialogModel", "processContents"));
    }
}

