/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonFileType;
import com.intellij.json.editor.JsonEditorOptions;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonCopyPastePostProcessor
extends CopyPastePostProcessor<TextBlockTransferableData> {
    static final List<TextBlockTransferableData> DATA_LIST = Collections.singletonList(new DumbData());

    @NotNull
    public List<TextBlockTransferableData> collectTransferableData(@NotNull PsiFile file, @NotNull Editor editor, int @NotNull [] startOffsets, int @NotNull [] endOffsets) {
        if (file == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(1);
        }
        if (startOffsets == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(2);
        }
        if (endOffsets == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(3);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<TextBlockTransferableData> extractTransferableData(@NotNull Transferable content) {
        if (content == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(5);
        }
        List<TextBlockTransferableData> list = DATA_LIST;
        if (list == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void processTransferableData(@NotNull Project project2, @NotNull Editor editor, @NotNull RangeMarker bounds, int caretOffset, @NotNull Ref<? super Boolean> indented, @NotNull List<? extends TextBlockTransferableData> values2) {
        if (project2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(8);
        }
        if (bounds == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(9);
        }
        if (indented == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(10);
        }
        if (values2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(11);
        }
        JsonCopyPastePostProcessor.fixCommasOnPaste(project2, editor, bounds);
    }

    private static void fixCommasOnPaste(@NotNull Project project2, @NotNull Editor editor, @NotNull RangeMarker bounds) {
        if (project2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(13);
        }
        if (bounds == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(14);
        }
        if (!JsonEditorOptions.getInstance().COMMA_ON_PASTE) {
            return;
        }
        if (!JsonCopyPastePostProcessor.isJsonEditor(project2, editor)) {
            return;
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project2);
        manager.commitDocument(editor.getDocument());
        PsiFile psiFile2 = manager.getPsiFile(editor.getDocument());
        if (psiFile2 == null) {
            return;
        }
        JsonCopyPastePostProcessor.fixTrailingComma(bounds, psiFile2, manager);
        JsonCopyPastePostProcessor.fixLeadingComma(bounds, psiFile2, manager);
    }

    private static boolean isJsonEditor(@NotNull Project project2, @NotNull Editor editor) {
        VirtualFile file;
        if (project2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(16);
        }
        if ((file = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) {
            return false;
        }
        FileType fileType = file.getFileType();
        if (fileType instanceof JsonFileType) {
            return true;
        }
        if (!ScratchUtil.isScratch((VirtualFile)file)) {
            return false;
        }
        return PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument()) instanceof JsonFile;
    }

    private static void fixLeadingComma(@NotNull RangeMarker bounds, @NotNull PsiFile psiFile2, @NotNull PsiDocumentManager manager) {
        PsiElement startElement;
        PsiElement propertyOrArrayItem;
        if (bounds == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(17);
        }
        if (psiFile2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(18);
        }
        if (manager == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(19);
        }
        PsiElement psiElement = propertyOrArrayItem = (startElement = JsonCopyPastePostProcessor.skipWhitespaces(psiFile2.findElementAt(bounds.getStartOffset()))) instanceof JsonProperty ? startElement : JsonCopyPastePostProcessor.getParentPropertyOrArrayItem(startElement);
        if (propertyOrArrayItem == null) {
            return;
        }
        PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)propertyOrArrayItem);
        if (prevSibling instanceof PsiErrorElement) {
            int offset = prevSibling.getTextRange().getEndOffset();
            ApplicationManager.getApplication().runWriteAction(() -> bounds.getDocument().insertString(offset, (CharSequence)","));
            manager.commitDocument(bounds.getDocument());
        }
    }

    @Nullable
    private static PsiElement getParentPropertyOrArrayItem(@Nullable PsiElement startElement) {
        PsiElement propertyOrArrayItem = PsiTreeUtil.getParentOfType((PsiElement)startElement, (Class[])new Class[]{JsonProperty.class, JsonArray.class});
        if (propertyOrArrayItem instanceof JsonArray) {
            for (JsonValue value2 : ((JsonArray)propertyOrArrayItem).getValueList()) {
                if (!PsiTreeUtil.isAncestor((PsiElement)value2, (PsiElement)startElement, (boolean)false)) continue;
                return value2;
            }
            return null;
        }
        return propertyOrArrayItem;
    }

    private static void fixTrailingComma(@NotNull RangeMarker bounds, @NotNull PsiFile psiFile2, @NotNull PsiDocumentManager manager) {
        PsiElement endElement;
        if (bounds == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(20);
        }
        if (psiFile2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(21);
        }
        if (manager == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(22);
        }
        if ((endElement = JsonCopyPastePostProcessor.skipWhitespaces(psiFile2.findElementAt(bounds.getEndOffset() - 1))) != null && endElement.getTextOffset() >= bounds.getEndOffset()) {
            endElement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)endElement);
        }
        if (endElement instanceof LeafPsiElement && ((LeafPsiElement)endElement).getElementType() == JsonElementTypes.COMMA) {
            PsiElement nextNext = JsonCopyPastePostProcessor.skipWhitespaces(endElement.getNextSibling());
            if (nextNext instanceof LeafPsiElement && (((LeafPsiElement)nextNext).getElementType() == JsonElementTypes.R_CURLY || ((LeafPsiElement)nextNext).getElementType() == JsonElementTypes.R_BRACKET)) {
                PsiElement finalEndElement = endElement;
                ApplicationManager.getApplication().runWriteAction(() -> finalEndElement.delete());
            }
        } else {
            PsiElement property2 = JsonCopyPastePostProcessor.getParentPropertyOrArrayItem(endElement);
            if (endElement instanceof PsiErrorElement || property2 != null && JsonCopyPastePostProcessor.skipWhitespaces(property2.getNextSibling()) instanceof PsiErrorElement) {
                PsiElement finalEndElement1 = endElement;
                ApplicationManager.getApplication().runWriteAction(() -> bounds.getDocument().insertString(JsonCopyPastePostProcessor.getOffset(property2, finalEndElement1), (CharSequence)","));
                manager.commitDocument(bounds.getDocument());
            }
        }
    }

    private static int getOffset(@Nullable PsiElement property2, @Nullable PsiElement finalEndElement1) {
        if (finalEndElement1 instanceof PsiErrorElement) {
            return finalEndElement1.getTextOffset();
        }
        assert (finalEndElement1 != null);
        return property2 != null ? property2.getTextRange().getEndOffset() : finalEndElement1.getTextOffset();
    }

    @Nullable
    private static PsiElement skipWhitespaces(@Nullable PsiElement element) {
        while (element instanceof PsiWhiteSpace) {
            element = element.getNextSibling();
        }
        return element;
    }

    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project2) {
        if (editor == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(23);
        }
        if (project2 == null) {
            JsonCopyPastePostProcessor.$$$reportNull$$$0(24);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startOffsets";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endOffsets";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/editor/JsonCopyPastePostProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 7: 
            case 12: 
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indented";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/editor/JsonCopyPastePostProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTransferableData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTransferableData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectTransferableData";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractTransferableData";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processTransferableData";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fixCommasOnPaste";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isJsonEditor";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fixLeadingComma";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fixTrailingComma";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 6 -> new IllegalStateException(string2);
        };
    }

    static class DumbData
    implements TextBlockTransferableData {
        private static final DataFlavor DATA_FLAVOR = new DataFlavor(JsonCopyPastePostProcessor.class, "class: JsonCopyPastePostProcessor");

        DumbData() {
        }

        @Nullable
        public DataFlavor getFlavor() {
            return DATA_FLAVOR;
        }
    }
}

