/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractShowDiffAction;
import com.intellij.openapi.vcs.actions.VcsContextUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.diff.DiffMixin;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Date;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ShowBaseRevisionAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowBaseRevisionAction.$$$reportNull$$$0(0);
        }
        Project project2 = Objects.requireNonNull(e.getProject());
        VirtualFile file = Objects.requireNonNull(VcsContextUtil.selectedFile(e.getDataContext()));
        AbstractVcs vcs = Objects.requireNonNull(ChangesUtil.getVcsForFile(file, project2));
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        ProgressManager.getInstance().run((Task)new MyTask(project2, file, vcs, editor));
    }

    @Nls
    private static String createMessage(@NotNull Project project2, @NotNull VcsRevisionDescription description2, @NotNull VirtualFile vf) {
        if (project2 == null) {
            ShowBaseRevisionAction.$$$reportNull$$$0(1);
        }
        if (description2 == null) {
            ShowBaseRevisionAction.$$$reportNull$$$0(2);
        }
        if (vf == null) {
            ShowBaseRevisionAction.$$$reportNull$$$0(3);
        }
        String commitMessage = IssueLinkHtmlRenderer.formatTextWithLinks(project2, StringUtil.notNullize((String)description2.getCommitMessage()));
        String message2 = VcsBundle.message("current.version.text", description2.getAuthor(), DateFormatUtil.formatPrettyDateTime((Date)description2.getRevisionDate()), commitMessage, description2.getRevisionNumber().asString(), vf.getName());
        return "<html><head>" + UIUtil.getCssFontDeclaration((Font)StartupUiUtil.getLabelFont()) + "</head><body>" + message2 + "</body></html>";
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowBaseRevisionAction.$$$reportNull$$$0(4);
        }
        boolean isEnabled = AbstractShowDiffAction.isEnabled(e.getDataContext(), false);
        e.getPresentation().setEnabled(isEnabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowBaseRevisionAction.$$$reportNull$$$0(5);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/ShowBaseRevisionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/ShowBaseRevisionAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createMessage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5 -> new IllegalStateException(string2);
        };
    }

    private static final class MyTask
    extends Task.Backgroundable {
        private final AbstractVcs vcs;
        private final VirtualFile selectedFile;
        private VcsRevisionDescription myDescription;
        private final Editor editor;

        private MyTask(Project project2, VirtualFile selectedFile, AbstractVcs vcs, Editor editor) {
            super(project2, VcsBundle.message("progress.title.loading.current.revision", new Object[0]), true);
            this.selectedFile = selectedFile;
            this.vcs = vcs;
            this.editor = editor;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyTask.$$$reportNull$$$0(0);
            }
            this.myDescription = Objects.requireNonNull((DiffMixin)((Object)this.vcs.getDiffProvider())).getCurrentRevisionDescription(this.selectedFile);
        }

        public void onSuccess() {
            if (this.myProject.isDisposed() || !this.myProject.isOpen()) {
                return;
            }
            if (this.myDescription != null) {
                NotificationPanel panel2 = new NotificationPanel();
                panel2.setText(ShowBaseRevisionAction.createMessage(this.myProject, this.myDescription, this.selectedFile));
                JBPopup message2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)panel2.getLabel()).createPopup();
                if (this.editor != null && this.editor.getComponent().isShowing()) {
                    message2.showInBestPositionFor(this.editor);
                } else {
                    message2.showCenteredInCurrentWindow(this.myProject);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/actions/ShowBaseRevisionAction$MyTask", "run"));
        }
    }

    static class NotificationPanel
    extends JPanel {
        protected final JEditorPane myLabel = new JEditorPane("text/html", "");

        NotificationPanel() {
            super(new BorderLayout());
            this.myLabel.setEditable(false);
            this.myLabel.setFont(UIUtil.getToolTipFont());
            this.myLabel.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
            this.setBorder((Border)JBUI.Borders.empty((int)1, (int)15));
            this.add((Component)this.myLabel, "Center");
            this.myLabel.setBackground(this.getBackground());
        }

        public void setText(@Nls String text2) {
            this.myLabel.setText(text2);
        }

        public JEditorPane getLabel() {
            return this.myLabel;
        }

        @Override
        public Color getBackground() {
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.NOTIFICATION_BACKGROUND);
            return color == null ? new Color(0xFFFFCC) : color;
        }
    }
}

