/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalChangeListImpl
extends LocalChangeList {
    @NotNull
    private final Project myProject;
    @NonNls
    @NotNull
    private final String myId;
    @NlsSafe
    @NotNull
    private final String myName;
    @NlsSafe
    @NotNull
    private final String myComment;
    @NotNull
    private final Set<? extends Change> myChanges;
    @Nullable
    private final ChangeListData myData;
    private final boolean myIsDefault;
    private final boolean myIsReadOnly;

    @NotNull
    public static LocalChangeListImpl createEmptyChangeListImpl(@NotNull Project project2, @NlsSafe @NotNull String name, @NonNls @Nullable String id) {
        if (project2 == null) {
            LocalChangeListImpl.$$$reportNull$$$0(0);
        }
        if (name == null) {
            LocalChangeListImpl.$$$reportNull$$$0(1);
        }
        LocalChangeListImpl localChangeListImpl = new Builder(project2, name).setId(id).build();
        if (localChangeListImpl == null) {
            LocalChangeListImpl.$$$reportNull$$$0(2);
        }
        return localChangeListImpl;
    }

    @NotNull
    public static String generateChangelistId() {
        String string2 = UUID.randomUUID().toString();
        if (string2 == null) {
            LocalChangeListImpl.$$$reportNull$$$0(3);
        }
        return string2;
    }

    private LocalChangeListImpl(@NotNull Project project2, @NonNls @NotNull String id, @NlsSafe @NotNull String name, @NlsSafe @NotNull String comment, @NotNull Set<? extends Change> changes, @Nullable ChangeListData data2, boolean isDefault, boolean isReadOnly) {
        if (project2 == null) {
            LocalChangeListImpl.$$$reportNull$$$0(4);
        }
        if (id == null) {
            LocalChangeListImpl.$$$reportNull$$$0(5);
        }
        if (name == null) {
            LocalChangeListImpl.$$$reportNull$$$0(6);
        }
        if (comment == null) {
            LocalChangeListImpl.$$$reportNull$$$0(7);
        }
        if (changes == null) {
            LocalChangeListImpl.$$$reportNull$$$0(8);
        }
        this.myProject = project2;
        this.myId = id;
        this.myName = name;
        this.myComment = comment;
        this.myChanges = changes;
        this.myData = data2;
        this.myIsDefault = isDefault;
        this.myIsReadOnly = isReadOnly;
    }

    @NotNull
    public Set<Change> getChanges() {
        Set<Change> set = Collections.unmodifiableSet(this.myChanges);
        if (set == null) {
            LocalChangeListImpl.$$$reportNull$$$0(9);
        }
        return set;
    }

    @Override
    @NotNull
    public String getId() {
        String string2 = this.myId;
        if (string2 == null) {
            LocalChangeListImpl.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            LocalChangeListImpl.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getComment() {
        String string2 = this.myComment;
        if (string2 == null) {
            LocalChangeListImpl.$$$reportNull$$$0(12);
        }
        return string2;
    }

    @Override
    public boolean isDefault() {
        return this.myIsDefault;
    }

    @Override
    public boolean isReadOnly() {
        return this.myIsReadOnly;
    }

    @Override
    @Nullable
    public ChangeListData getData() {
        return this.myData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalChangeListImpl list = (LocalChangeListImpl)o;
        return this.myName.equals(list.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.myName;
    }

    @Override
    public LocalChangeListImpl copy() {
        return this;
    }

    @Override
    public void setComment(@Nullable String comment) {
        ChangeListManager.getInstance(this.myProject).editComment(this.myName, comment);
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        ChangeListManager.getInstance(this.myProject).setReadOnly(this.myName, isReadOnly);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/LocalChangeListImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/LocalChangeListImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyChangeListImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateChangelistId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyChangeListImpl";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 9, 10, 11, 12 -> new IllegalStateException(string2);
        };
    }

    public static class Builder {
        @NotNull
        private final Project myProject;
        @NotNull
        private final String myName;
        @Nullable
        private String myId;
        @NotNull
        private String myComment;
        @NotNull
        private Set<Change> myChanges;
        @Nullable
        private ChangeListData myData;
        private boolean myIsDefault;
        private boolean myIsReadOnly;

        public Builder(@NotNull Project project2, @NlsSafe @NotNull String name) {
            if (project2 == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (name == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myComment = "";
            this.myChanges = new HashSet<Change>();
            this.myData = null;
            this.myIsDefault = false;
            this.myIsReadOnly = false;
            this.myProject = project2;
            this.myName = name;
        }

        public Builder(@NotNull LocalChangeListImpl list) {
            if (list == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myComment = "";
            this.myChanges = new HashSet<Change>();
            this.myData = null;
            this.myIsDefault = false;
            this.myIsReadOnly = false;
            this.myProject = list.myProject;
            this.myId = list.myId;
            this.myName = list.myName;
            this.myComment = list.myComment;
            this.myChanges = new HashSet<Change>(list.myChanges);
            this.myData = list.myData;
            this.myIsDefault = list.myIsDefault;
            this.myIsReadOnly = list.myIsReadOnly;
        }

        public Builder setId(@NonNls @Nullable String value2) {
            this.myId = value2;
            return this;
        }

        public Builder setComment(@NlsSafe @NotNull String value2) {
            if (value2 == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myComment = value2;
            return this;
        }

        public Builder setChanges(@NotNull Collection<? extends Change> changes) {
            if (changes == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myChanges.clear();
            this.myChanges.addAll(changes);
            return this;
        }

        public Builder setChangesCollection(@NotNull Set<Change> changes) {
            if (changes == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myChanges = changes;
            return this;
        }

        public Builder setData(@Nullable ChangeListData value2) {
            this.myData = value2;
            return this;
        }

        public Builder setDefault(boolean value2) {
            this.myIsDefault = value2;
            return this;
        }

        public Builder setReadOnly(boolean value2) {
            this.myIsReadOnly = value2;
            return this;
        }

        @NotNull
        public LocalChangeListImpl build() {
            String id = this.myId != null ? this.myId : LocalChangeListImpl.generateChangelistId();
            return new LocalChangeListImpl(this.myProject, id, this.myName, this.myComment, this.myChanges, this.myData, this.myIsDefault, this.myIsReadOnly);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/LocalChangeListImpl$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setComment";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setChanges";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setChangesCollection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

