/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListChangesSupplier;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vcs.changes.ui.CommitDialogChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.openapi.vcs.changes.ui.DiffCommitMessageEditor;
import com.intellij.openapi.vcs.changes.ui.MultipleLocalChangeListsBrowser;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandlerKt;
import com.intellij.vcs.commit.NonModalCommitPromoter;
import com.intellij.vcs.commit.SingleChangeListCommitWorkflow;
import com.intellij.vcs.commit.SingleChangeListCommitWorkflowUi;
import java.awt.Component;
import java.util.Collection;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\rH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DefaultCommitChangeListDialog;", "Lcom/intellij/openapi/vcs/changes/ui/CommitChangeListDialog;", "workflow", "Lcom/intellij/vcs/commit/SingleChangeListCommitWorkflow;", "(Lcom/intellij/vcs/commit/SingleChangeListCommitWorkflow;)V", "browser", "Lcom/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser;", "changeListEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/vcs/commit/SingleChangeListCommitWorkflowUi$ChangeListListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addChangeListListener", "", "listener", "parent", "Lcom/intellij/openapi/Disposable;", "changeListChanged", "createCenterPanel", "Ljavax/swing/JComponent;", "createTitlePane", "getBrowser", "Lcom/intellij/openapi/vcs/changes/ui/CommitDialogChangesBrowser;", "intellij.platform.vcs.impl"})
public final class DefaultCommitChangeListDialog
extends CommitChangeListDialog {
    @NotNull
    private final EventDispatcher<SingleChangeListCommitWorkflowUi.ChangeListListener> changeListEventDispatcher;
    @NotNull
    private final MultipleLocalChangeListsBrowser browser;

    public DefaultCommitChangeListDialog(@NotNull SingleChangeListCommitWorkflow workflow) {
        Intrinsics.checkNotNullParameter((Object)workflow, (String)"workflow");
        super(workflow);
        EventDispatcher eventDispatcher = EventDispatcher.create(SingleChangeListCommitWorkflowUi.ChangeListListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(SingleChangeListC\u2026ListListener::class.java)");
        this.changeListEventDispatcher = eventDispatcher;
        this.browser = new MultipleLocalChangeListsBrowser(this.getProject(), (Collection<AbstractVcs>)workflow.getVcses(), true, true, workflow.isDefaultCommitEnabled(), workflow.isPartialCommitEnabled());
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        LineStatusTrackerManager.Companion.getInstanceImpl(project2).resetExcludedFromCommitMarkers();
        ChangesTree changesTree = this.browser.getViewer();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)changesTree), (String)"browser.viewer");
        CurrentBranchComponent branchComponent2 = new CurrentBranchComponent(changesTree, (Function0<? extends Iterable<? extends FilePath>>)((Function0)new Function0<Iterable<? extends FilePath>>(this){
            final /* synthetic */ DefaultCommitChangeListDialog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Iterable<FilePath> invoke() {
                return AbstractCommitWorkflowHandlerKt.getDisplayedPaths(this.this$0);
            }
        }));
        Disposer.register((Disposable)this, (Disposable)branchComponent2);
        UIUtil.addBorder((JComponent)((JComponent)((Object)branchComponent2)), (Border)((Border)JBUI.Borders.emptyRight((int)16)));
        this.getBrowserBottomPanel().add((Component)((Object)branchComponent2));
        LocalChangeList initialChangeList = workflow.getInitialChangeList();
        if (initialChangeList != null) {
            this.browser.setSelectedChangeList(initialChangeList);
        }
        this.browser.getViewer().setIncludedChanges(workflow.getInitiallyIncluded());
        this.browser.getViewer().rebuildTree();
        this.browser.getViewer().setKeepTreeState(true);
        this.browser.setBottomDiffComponent(() -> DefaultCommitChangeListDialog._init_$lambda$1(this));
        this.browser.setSelectedListChangeListener((SingleChangeListCommitWorkflowUi.ChangeListListener)this.changeListEventDispatcher.getMulticaster());
        this.addChangeListListener(new SingleChangeListCommitWorkflowUi.ChangeListListener(){

            @Override
            public void changeListChanged(@NotNull LocalChangeList oldChangeList, @NotNull LocalChangeList newChangeList) {
                Intrinsics.checkNotNullParameter((Object)oldChangeList, (String)"oldChangeList");
                Intrinsics.checkNotNullParameter((Object)newChangeList, (String)"newChangeList");
                this.changeListChanged();
            }
        }, this);
    }

    @Nullable
    protected JComponent createTitlePane() {
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        return NonModalCommitPromoter.Companion.getInstance(project2).getPromotionPanel(this);
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        BorderLayoutPanel borderLayoutPanel;
        BorderLayoutPanel $this$createCenterPanel_u24lambda_u242 = borderLayoutPanel = JBUI.Panels.simplePanel((Component)super.createCenterPanel());
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u242.putClientProperty((Object)"isVisualPaddingCompensatedOnComponentLevel", (Object)false);
        JBInsets jBInsets = UIUtil.getRegularPanelInsets();
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"getRegularPanelInsets()");
        JBInsets insets = jBInsets;
        $this$createCenterPanel_u24lambda_u242.setBorder((Border)new EmptyBorder(insets.top, insets.left, 0, insets.right));
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel;
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel2, (String)"simplePanel(super.create\u2026t, 0, insets.right)\n    }");
        return (JComponent)borderLayoutPanel2;
    }

    @Override
    @NotNull
    public CommitDialogChangesBrowser getBrowser() {
        return this.browser;
    }

    @Override
    public void addChangeListListener(@NotNull SingleChangeListCommitWorkflowUi.ChangeListListener listener2, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.changeListEventDispatcher.addListener((EventListener)listener2, parent);
    }

    private final void changeListChanged() {
        this.getCommitMessageComponent().setChangesSupplier(new ChangeListChangesSupplier(this.getChangeList()));
        this.updateWarning();
    }

    private static final JComponent _init_$lambda$1(DefaultCommitChangeListDialog this$0) {
        DiffCommitMessageEditor diffCommitMessageEditor;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Project project2 = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        CommitMessage commitMessage = this$0.getCommitMessageComponent();
        Intrinsics.checkNotNullExpressionValue((Object)commitMessage, (String)"commitMessageComponent");
        DiffCommitMessageEditor editor = diffCommitMessageEditor = new DiffCommitMessageEditor(project2, commitMessage);
        boolean bl = false;
        Disposer.register((Disposable)this$0, (Disposable)editor);
        return diffCommitMessageEditor;
    }
}

