/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;

public class XmlTextFilter
implements ElementFilter {
    protected final String[] myValue;

    public XmlTextFilter(@NonNls String value2) {
        this.myValue = new String[1];
        this.myValue[0] = value2;
    }

    public XmlTextFilter(String ... values2) {
        this.myValue = values2;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        if (element != null) {
            String text2 = this.getTextByElement(element);
            for (String value2 : this.myValue) {
                if (value2 != null && !value2.equals(text2)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        Object ret = "(";
        for (int i = 0; i < this.myValue.length; ++i) {
            ret = (String)ret + this.myValue[i];
            if (i >= this.myValue.length - 1) continue;
            ret = (String)ret + " | ";
        }
        ret = (String)ret + ")";
        return ret;
    }

    protected String getTextByElement(Object element) {
        String elementValue = null;
        if (element instanceof PsiNamedElement) {
            elementValue = element instanceof XmlTag ? ((XmlTag)element).getLocalName() : ((PsiNamedElement)element).getName();
        } else if (element instanceof PsiElement) {
            elementValue = ((PsiElement)element).getText();
        }
        return elementValue;
    }
}

