/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.util.SmartList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReplacementInfoImpl
implements ReplacementInfo {
    @NotNull
    private final MatchResult matchResult;
    private final List<SmartPsiElementPointer<PsiElement>> matchesPtrList;
    private final Map<String, MatchResult> variableMap;
    private final Map<PsiElement, String> elementToVariableNameMap;
    private final Map<String, String> sourceNameToSearchPatternNameMap;
    private String replacement;

    ReplacementInfoImpl(@NotNull MatchResult matchResult, @NotNull Project project2) {
        if (matchResult == null) {
            ReplacementInfoImpl.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            ReplacementInfoImpl.$$$reportNull$$$0(1);
        }
        this.matchesPtrList = new SmartList();
        this.variableMap = new HashMap<String, MatchResult>();
        this.elementToVariableNameMap = new HashMap<PsiElement, String>(1);
        this.sourceNameToSearchPatternNameMap = new HashMap<String, String>(1);
        this.matchResult = matchResult;
        this.init(project2);
    }

    private void init(@NotNull Project project2) {
        if (project2 == null) {
            ReplacementInfoImpl.$$$reportNull$$$0(2);
        }
        this.fillPointerList(project2);
        this.fillVariableMap(this.matchResult.getRoot());
        for (Map.Entry<String, MatchResult> entry2 : this.variableMap.entrySet()) {
            this.fillElementToVariableNameMap(entry2.getKey(), entry2.getValue());
        }
    }

    @Override
    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(@NotNull String replacement) {
        if (replacement == null) {
            ReplacementInfoImpl.$$$reportNull$$$0(3);
        }
        this.replacement = replacement;
    }

    @Override
    @Nullable
    public PsiElement getMatch(int index) {
        return this.matchesPtrList.get(index).getElement();
    }

    @Override
    public int getMatchesCount() {
        return this.matchesPtrList.size();
    }

    @Override
    public MatchResult getNamedMatchResult(@NotNull String name) {
        if (name == null) {
            ReplacementInfoImpl.$$$reportNull$$$0(4);
        }
        return this.variableMap.get(name);
    }

    @Override
    @NotNull
    public MatchResult getMatchResult() {
        MatchResult matchResult = this.matchResult;
        if (matchResult == null) {
            ReplacementInfoImpl.$$$reportNull$$$0(5);
        }
        return matchResult;
    }

    @Override
    public String getVariableName(@NotNull PsiElement element) {
        if (element == null) {
            ReplacementInfoImpl.$$$reportNull$$$0(6);
        }
        return this.elementToVariableNameMap.get(element);
    }

    @Override
    public String getSearchPatternName(@NotNull String sourceName) {
        if (sourceName == null) {
            ReplacementInfoImpl.$$$reportNull$$$0(7);
        }
        return this.sourceNameToSearchPatternNameMap.get(sourceName);
    }

    private void fillPointerList(@NotNull Project project2) {
        if (project2 == null) {
            ReplacementInfoImpl.$$$reportNull$$$0(8);
        }
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)project2);
        if ("__multi_line__".equals(this.matchResult.getName())) {
            Iterator<MatchResult> i = this.matchResult.getChildren().iterator();
            while (i.hasNext()) {
                MatchResult r = i.next();
                if (!"__line__".equals(r.getName())) continue;
                PsiElement element = r.getMatch();
                if (element instanceof PsiDocCommentBase && i.hasNext()) {
                    MatchResult son = i.next();
                    if (!"__line__".equals(son.getName()) || !StructuralSearchUtil.isDocCommentOwner(son.getMatch())) {
                        this.matchesPtrList.add((SmartPsiElementPointer<PsiElement>)manager.createSmartPsiElementPointer(element));
                    }
                    element = son.getMatch();
                }
                this.matchesPtrList.add((SmartPsiElementPointer<PsiElement>)manager.createSmartPsiElementPointer(element));
            }
        } else {
            this.matchesPtrList.add((SmartPsiElementPointer<PsiElement>)manager.createSmartPsiElementPointer(this.matchResult.getMatch()));
        }
    }

    private void fillElementToVariableNameMap(String name, MatchResult matchResult) {
        PsiElement match2;
        boolean multiMatch;
        boolean bl = multiMatch = matchResult.isMultipleMatch() || matchResult.isScopeMatch();
        if (matchResult.hasChildren() && multiMatch) {
            for (MatchResult r : matchResult.getChildren()) {
                this.fillElementToVariableNameMap(name, r);
            }
        } else if (!multiMatch && (match2 = matchResult.getMatch()) != null) {
            this.elementToVariableNameMap.put(match2, name);
        }
    }

    private void fillVariableMap(MatchResult r) {
        String name = r.getName();
        if (name != null) {
            this.variableMap.putIfAbsent(name, r);
            this.sourceNameToSearchPatternNameMap.put(r.getMatchImage(), name);
        }
        if (!r.isScopeMatch() || !r.isMultipleMatch()) {
            for (MatchResult matchResult : r.getChildren()) {
                this.fillVariableMap(matchResult);
            }
        } else if (r.hasChildren()) {
            this.fillVariableMap(r.getChildren().get(0));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchResult";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/replace/impl/ReplacementInfoImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/replace/impl/ReplacementInfoImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setReplacement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNamedMatchResult";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVariableName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPatternName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillPointerList";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5 -> new IllegalStateException(string2);
        };
    }
}

