/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.ui.AbstractDomElementComponent;
import com.intellij.util.xml.ui.DomUIControl;
import com.intellij.util.xml.ui.DomUIFactory;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class BasicDomElementComponent<T extends DomElement>
extends AbstractDomElementComponent<T> {
    private static final Logger LOG = Logger.getInstance(BasicDomElementComponent.class);
    private final Map<JComponent, DomUIControl> myBoundComponents = new HashMap<JComponent, DomUIControl>();

    public BasicDomElementComponent(T domElement) {
        super(domElement);
    }

    protected final void bindProperties() {
        this.bindProperties((DomElement)this.getDomElement());
    }

    protected boolean commitOnEveryChange(GenericDomValue element) {
        return false;
    }

    protected final void bindProperties(DomElement domElement) {
        if (domElement == null) {
            return;
        }
        DomElementAnnotationsManager.getInstance(domElement.getManager().getProject()).addHighlightingListener(new DomElementAnnotationsManager.DomHighlightingListener(){

            @Override
            public void highlightingFinished(@NotNull DomFileElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (BasicDomElementComponent.this.getComponent().isShowing() && element.isValid()) {
                        BasicDomElementComponent.this.updateHighlighting();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/ui/BasicDomElementComponent$1", "highlightingFinished"));
            }
        }, this);
        for (AbstractDomChildrenDescription abstractDomChildrenDescription : domElement.getGenericInfo().getChildrenDescriptions()) {
            JComponent boundComponent = this.getBoundComponent(abstractDomChildrenDescription);
            if (boundComponent == null) continue;
            if (abstractDomChildrenDescription instanceof DomFixedChildDescription && DomUtil.isGenericValueType(abstractDomChildrenDescription.getType())) {
                if (abstractDomChildrenDescription.getValues(domElement).size() != 1) continue;
                GenericDomValue element = (GenericDomValue)domElement.getManager().createStableValue(() -> domElement.isValid() ? (GenericDomValue)description2.getValues(domElement).get(0) : null);
                this.doBind(DomUIFactory.createControl(element, this.commitOnEveryChange(element)), boundComponent);
                continue;
            }
            if (!(abstractDomChildrenDescription instanceof DomCollectionChildDescription)) continue;
            this.doBind(DomUIFactory.getDomUIFactory().createCollectionControl(domElement, (DomCollectionChildDescription)abstractDomChildrenDescription), boundComponent);
        }
        this.reset();
    }

    protected void doBind(DomUIControl control, JComponent boundComponent) {
        this.myBoundComponents.put(boundComponent, control);
        control.bind(boundComponent);
        this.addComponent(control);
    }

    private JComponent getBoundComponent(AbstractDomChildrenDescription description2) {
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                if (!(description2 instanceof DomChildrenDescription)) continue;
                DomChildrenDescription childrenDescription = (DomChildrenDescription)description2;
                if (!this.convertFieldName(field.getName(), childrenDescription).equals(childrenDescription.getXmlElementName()) || !(field.get(this) instanceof JComponent)) continue;
                return (JComponent)field.get(this);
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    private String convertFieldName(@NotNull String propertyName, DomChildrenDescription description2) {
        String unpluralizedStr;
        if (propertyName == null) {
            BasicDomElementComponent.$$$reportNull$$$0(0);
        }
        propertyName = StringUtil.trimStart((String)propertyName, (String)"my");
        String convertedName = description2.getDomNameStrategy((DomElement)this.getDomElement()).convertName(propertyName);
        if (description2 instanceof DomCollectionChildDescription && (unpluralizedStr = StringUtil.unpluralize((String)convertedName)) != null) {
            String string2 = unpluralizedStr;
            if (string2 == null) {
                BasicDomElementComponent.$$$reportNull$$$0(1);
            }
            return string2;
        }
        String string3 = convertedName;
        if (string3 == null) {
            BasicDomElementComponent.$$$reportNull$$$0(2);
        }
        return string3;
    }

    public final Project getProject() {
        return this.getDomElement().getManager().getProject();
    }

    public final Module getModule() {
        return this.getDomElement().getModule();
    }

    protected final DomUIControl getDomControl(JComponent component2) {
        return this.myBoundComponents.get(component2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/ui/BasicDomElementComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/ui/BasicDomElementComponent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertFieldName";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }
}

