/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.UserActivityListener;
import com.intellij.util.Alarm;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.CommittableUtil;

public class CommitablePanelUserActivityListener
implements UserActivityListener,
Disposable {
    private final Committable myPanel;
    private final Project myProject;
    private final Alarm myAlarm = new Alarm();
    private boolean myApplying;

    public CommitablePanelUserActivityListener(Project project2) {
        this(null, project2);
    }

    public CommitablePanelUserActivityListener(Committable panel2, Project project2) {
        this.myPanel = panel2;
        this.myProject = project2;
    }

    public final void stateChanged() {
        if (this.myApplying) {
            return;
        }
        CommitablePanelUserActivityListener.cancel();
        this.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            this.myApplying = true;
            CommitablePanelUserActivityListener.cancel();
            try {
                this.applyChanges();
            }
            finally {
                this.myApplying = false;
            }
        }, 717);
    }

    private static void cancel() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.cancel();
        }
    }

    protected void applyChanges() {
        if (this.myPanel != null) {
            this.commit(this.myPanel);
        }
    }

    protected final void commit(Committable panel2) {
        ((CommittableUtil)this.getProject().getService(CommittableUtil.class)).commit(panel2);
    }

    protected final Project getProject() {
        return this.myProject;
    }

    public final boolean isWaiting() {
        return !this.myAlarm.isEmpty();
    }

    public final void cancelAllRequests() {
        this.myAlarm.cancelAllRequests();
    }

    public void dispose() {
        this.cancelAllRequests();
    }
}

