/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryModel;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.table.CommitSelectionImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u000e\u001a\u00020\u000fH$J'\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\b\u001a\u00020\tH\u0014\u00a2\u0006\u0002\u0010\u0015J-\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH$\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u001f"}, d2={"Lcom/intellij/vcs/log/ui/actions/history/FileHistoryOneCommitAction;", "T", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getDetailsGetter", "Lcom/intellij/vcs/log/data/DataGetter;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "isEnabled", "", "selection", "Lcom/intellij/vcs/log/history/FileHistoryModel;", "detail", "(Lcom/intellij/vcs/log/history/FileHistoryModel;Lcom/intellij/vcs/log/VcsCommitMetadata;Lcom/intellij/openapi/actionSystem/AnActionEvent;)Z", "performAction", "project", "Lcom/intellij/openapi/project/Project;", "model", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/history/FileHistoryModel;Lcom/intellij/vcs/log/VcsCommitMetadata;Lcom/intellij/openapi/actionSystem/AnActionEvent;)V", "showError", "t", "", "update", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistoryOneCommitAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryOneCommitAction.kt\ncom/intellij/vcs/log/ui/actions/history/FileHistoryOneCommitAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public abstract class FileHistoryOneCommitAction<T extends VcsCommitMetadata>
extends AnAction
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        VcsCommitMetadata vcsCommitMetadata;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        VcsLogData logData = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        FileHistoryModel model2 = (FileHistoryModel)e.getData(VcsLogInternalDataKeys.FILE_HISTORY_MODEL);
        if (project2 == null || logData == null || selection == null || model2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        if (selection.getSize() != 1) {
            e.getPresentation().setEnabled(false);
            return;
        }
        VcsCommitMetadata vcsCommitMetadata2 = (VcsCommitMetadata)CollectionsKt.singleOrNull(CommitSelectionImpl.Companion.getCachedDetails$intellij_platform_vcs_log_impl(selection, this.getDetailsGetter(logData)));
        if (vcsCommitMetadata2 != null) {
            VcsCommitMetadata vcsCommitMetadata3;
            VcsCommitMetadata it = vcsCommitMetadata3 = vcsCommitMetadata2;
            boolean bl = false;
            vcsCommitMetadata = !(it instanceof LoadingDetails) ? vcsCommitMetadata3 : null;
        } else {
            vcsCommitMetadata = null;
        }
        VcsCommitMetadata detail = vcsCommitMetadata;
        e.getPresentation().setEnabled(this.isEnabled(model2, detail, e));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        Object object = e.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(CommonDataKeys.PROJECT)");
        Project project2 = (Project)object;
        Object object2 = e.getRequiredData(VcsLogInternalDataKeys.LOG_DATA);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"e.getRequiredData(VcsLogInternalDataKeys.LOG_DATA)");
        VcsLogData logData = (VcsLogData)object2;
        Object object3 = e.getRequiredData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"e.getRequiredData(VcsLog\u2026VCS_LOG_COMMIT_SELECTION)");
        VcsLogCommitSelection selection = (VcsLogCommitSelection)object3;
        Object object4 = e.getRequiredData(VcsLogInternalDataKeys.FILE_HISTORY_MODEL);
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"e.getRequiredData(VcsLog\u2026aKeys.FILE_HISTORY_MODEL)");
        FileHistoryModel model2 = (FileHistoryModel)object4;
        if (selection.getSize() != 1) {
            return;
        }
        this.getDetailsGetter(logData).loadCommitsData(selection.getIds(), arg_0 -> FileHistoryOneCommitAction.actionPerformed$lambda$1((Function1)new Function1<List<? extends T>, Unit>(this, project2, model2, e){
            final /* synthetic */ FileHistoryOneCommitAction<T> this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ FileHistoryModel $model;
            final /* synthetic */ AnActionEvent $e;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$model = $model;
                this.$e = $e;
                super(1);
            }

            public final void invoke(@NotNull List<? extends T> details) {
                Intrinsics.checkNotNullParameter(details, (String)"details");
                if (!details.isEmpty()) {
                    this.this$0.performAction(this.$project, this.$model, (VcsCommitMetadata)CollectionsKt.single(details), this.$e);
                }
            }
        }, arg_0), (Consumer<Throwable>)((Consumer)arg_0 -> FileHistoryOneCommitAction.actionPerformed$lambda$2((Function1)new Function1<Throwable, Unit>(this, project2){
            final /* synthetic */ FileHistoryOneCommitAction<T> this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                FileHistoryOneCommitAction.access$showError(this.this$0, this.$project, t);
            }
        }, arg_0)), null);
    }

    private final void showError(Project project2, Throwable t) {
        Object[] objectArray = new Object[]{t.getMessage()};
        VcsBalloonProblemNotifier.showOverChangesView(project2, VcsLogBundle.message("file.history.action.could.not.load.selected.commits.message", objectArray), MessageType.ERROR, new NamedRunnable[0]);
    }

    protected boolean isEnabled(@NotNull FileHistoryModel selection, @Nullable T detail, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return true;
    }

    @NotNull
    protected abstract DataGetter<T> getDetailsGetter(@NotNull VcsLogData var1);

    protected abstract void performAction(@NotNull Project var1, @NotNull FileHistoryModel var2, @NotNull T var3, @NotNull AnActionEvent var4);

    private static final void actionPerformed$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void actionPerformed$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$showError(FileHistoryOneCommitAction $this, Project project2, Throwable t) {
        $this.showError(project2, t);
    }
}

