/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.config;

import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.config.ConfigFileSearcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConfigFilesTreeBuilder {
    private final JTree myTree;
    private static final Comparator<PsiFile> FILE_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());

    public ConfigFilesTreeBuilder(JTree tree2) {
        this.myTree = tree2;
        ConfigFilesTreeBuilder.installSearch(tree2);
    }

    public Set<PsiFile> buildTree(DefaultMutableTreeNode root, ConfigFileSearcher ... searchers) {
        MultiMap files2 = new MultiMap();
        MultiMap jars = new MultiMap();
        MultiMap virtualFiles2 = new MultiMap();
        for (ConfigFileSearcher searcher : searchers) {
            files2.putAllValues(searcher.getFilesByModules());
            jars.putAllValues(searcher.getJars());
            virtualFiles2.putAllValues(searcher.getVirtualFiles());
        }
        HashSet<PsiFile> psiFiles = new HashSet<PsiFile>(this.buildModuleNodes((MultiMap<Module, PsiFile>)files2, (MultiMap<VirtualFile, PsiFile>)jars, root));
        for (Map.Entry entry2 : virtualFiles2.entrySet()) {
            DefaultMutableTreeNode node = this.createFileNode(entry2.getKey());
            ArrayList<PsiFile> list = new ArrayList<PsiFile>((Collection)entry2.getValue());
            list.sort(FILE_COMPARATOR);
            for (PsiFile file : list) {
                node.add(this.createFileNode(file));
            }
            root.add(node);
        }
        return psiFiles;
    }

    public DefaultMutableTreeNode addFile(VirtualFile file) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        DefaultMutableTreeNode treeNode = this.createFileNode(file);
        root.add(treeNode);
        DefaultTreeModel model2 = (DefaultTreeModel)this.myTree.getModel();
        model2.nodeStructureChanged(root);
        return treeNode;
    }

    public Set<PsiFile> buildModuleNodes(MultiMap<Module, PsiFile> files2, MultiMap<VirtualFile, PsiFile> jars, DefaultMutableTreeNode root) {
        HashSet<PsiFile> psiFiles = new HashSet<PsiFile>();
        ArrayList modules = new ArrayList(files2.keySet());
        modules.sort(ModulesAlphaComparator.INSTANCE);
        for (Module module : modules) {
            DefaultMutableTreeNode moduleNode = this.createFileNode(module);
            root.add(moduleNode);
            if (!files2.containsKey((Object)module)) continue;
            ArrayList moduleFiles = new ArrayList(files2.get((Object)module));
            MultiMap filesByType = new MultiMap();
            for (PsiFile file : moduleFiles) {
                filesByType.putValue((Object)file.getFileType(), (Object)file);
            }
            if (ConfigFilesTreeBuilder.hasNonEmptyGroups((MultiMap<FileType, PsiFile>)filesByType)) {
                for (Map.Entry entry2 : filesByType.entrySet()) {
                    DefaultMutableTreeNode fileTypeNode = this.createFileNode(entry2.getKey());
                    moduleNode.add(fileTypeNode);
                    this.addChildrenFiles(psiFiles, fileTypeNode, new ArrayList((Collection)entry2.getValue()));
                }
                continue;
            }
            this.addChildrenFiles(psiFiles, moduleNode, moduleFiles);
        }
        ArrayList sortedJars = new ArrayList(jars.keySet());
        sortedJars.sort((o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName()));
        for (VirtualFile file : sortedJars) {
            ArrayList<PsiFile> list;
            PsiFile jar;
            if (!file.isValid() || (jar = ((PsiFile)(list = new ArrayList<PsiFile>(jars.get((Object)file))).get(0)).getManager().findFile(file)) == null) continue;
            DefaultMutableTreeNode jarNode = this.createFileNode(jar);
            root.add(jarNode);
            list.sort(FILE_COMPARATOR);
            for (PsiFile psiFile2 : list) {
                jarNode.add(this.createFileNode(psiFile2));
                psiFiles.add(psiFile2);
            }
        }
        return psiFiles;
    }

    @Nls
    private static String getFileTypeNodeName(FileType fileType) {
        return XmlBundle.message("xml.tree.config.files.type", fileType.getName());
    }

    private static boolean hasNonEmptyGroups(MultiMap<FileType, PsiFile> filesByType) {
        long nonEmptyGroups = filesByType.entrySet().stream().map(Map.Entry::getValue).filter(files2 -> files2 != null && !files2.isEmpty()).limit(2L).count();
        return nonEmptyGroups > 1L;
    }

    private void addChildrenFiles(@NotNull Set<? super PsiFile> psiFiles, DefaultMutableTreeNode parentNode, @NotNull List<? extends PsiFile> moduleFiles) {
        if (psiFiles == null) {
            ConfigFilesTreeBuilder.$$$reportNull$$$0(0);
        }
        if (moduleFiles == null) {
            ConfigFilesTreeBuilder.$$$reportNull$$$0(1);
        }
        moduleFiles.sort(FILE_COMPARATOR);
        for (PsiFile psiFile2 : moduleFiles) {
            DefaultMutableTreeNode fileNode = this.createFileNode(psiFile2);
            parentNode.add(fileNode);
            psiFiles.add((PsiFile)psiFile2);
        }
    }

    protected DefaultMutableTreeNode createFileNode(Object file) {
        return new DefaultMutableTreeNode(file);
    }

    public static void renderNode(Object value2, boolean expanded, ColoredTreeCellRenderer renderer) {
        if (!(value2 instanceof DefaultMutableTreeNode)) {
            return;
        }
        Object object = ((DefaultMutableTreeNode)value2).getUserObject();
        if (object instanceof FileType) {
            FileType fileType = (FileType)object;
            Icon icon2 = fileType.getIcon();
            renderer.setIcon(icon2);
            renderer.append(ConfigFilesTreeBuilder.getFileTypeNodeName(fileType), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (object instanceof Module) {
            Module module = (Module)object;
            Icon icon3 = ModuleType.get((Module)module).getIcon();
            renderer.setIcon(icon3);
            String moduleName = module.getName();
            renderer.append(moduleName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (object instanceof PsiFile) {
            PsiFile psiFile2 = (PsiFile)object;
            Icon icon4 = psiFile2.getIcon(0);
            renderer.setIcon(icon4);
            String fileName = psiFile2.getName();
            renderer.append(fileName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            VirtualFile virtualFile = psiFile2.getVirtualFile();
            if (virtualFile != null) {
                ConfigFilesTreeBuilder.renderPath(renderer, virtualFile);
            }
        } else if (object instanceof VirtualFile) {
            VirtualFile file = (VirtualFile)object;
            renderer.setIcon(VirtualFilePresentation.getIcon((VirtualFile)file));
            renderer.append(file.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            ConfigFilesTreeBuilder.renderPath(renderer, file);
        }
    }

    private static void renderPath(ColoredTreeCellRenderer renderer, VirtualFile virtualFile) {
        String path2 = virtualFile.getPath();
        int i = path2.indexOf("!/");
        if (i >= 0) {
            path2 = path2.substring(i + "!/".length());
        }
        renderer.append(" (" + StringUtil.trimEnd((String)StringUtil.trimEnd((String)path2, (String)virtualFile.getName()), (String)"/") + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    public static void installSearch(JTree tree2) {
        TreeSpeedSearch.installOn((JTree)tree2, (boolean)false, treePath -> {
            Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
            if (object instanceof Module) {
                return ((Module)object).getName();
            }
            if (object instanceof PsiFile) {
                return ((PsiFile)object).getName();
            }
            if (object instanceof VirtualFile) {
                return ((VirtualFile)object).getName();
            }
            return "";
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "moduleFiles";
                break;
            }
        }
        objectArray[1] = "com/intellij/xml/config/ConfigFilesTreeBuilder";
        objectArray[2] = "addChildrenFiles";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

