/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.widget;

import com.intellij.icons.AllIcons;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.StatusText;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.settings.mappings.JsonSchemaMappingsConfigurable;
import com.jetbrains.jsonSchema.widget.JsonSchemaStatusPopup;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaInfoPopupStep
extends BaseListPopupStep<JsonSchemaInfo>
implements ListPopupStepEx<JsonSchemaInfo> {
    private final Project myProject;
    @Nullable
    private final VirtualFile myVirtualFile;
    @NotNull
    private final JsonSchemaService myService;
    private static final Icon EMPTY_ICON = JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)AllIcons.General.Add.getIconWidth()));

    public JsonSchemaInfoPopupStep(@NotNull List<JsonSchemaInfo> allSchemas, @NotNull Project project2, @Nullable VirtualFile virtualFile, @NotNull JsonSchemaService service, @Nullable @NlsContexts.PopupTitle String title2) {
        if (allSchemas == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(1);
        }
        if (service == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(2);
        }
        super(title2, allSchemas);
        this.myProject = project2;
        this.myVirtualFile = virtualFile;
        this.myService = service;
    }

    @NotNull
    public String getTextFor(JsonSchemaInfo value2) {
        String string2 = value2 == null ? "" : value2.getDescription();
        if (string2 == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public Icon getIconFor(JsonSchemaInfo value2) {
        if (value2 == JsonSchemaStatusPopup.ADD_MAPPING) {
            return AllIcons.General.Add;
        }
        if (value2 == JsonSchemaStatusPopup.EDIT_MAPPINGS) {
            return AllIcons.Actions.Edit;
        }
        if (value2 == JsonSchemaStatusPopup.LOAD_REMOTE) {
            return AllIcons.Actions.Refresh;
        }
        if (value2 == JsonSchemaStatusPopup.IGNORE_FILE) {
            return AllIcons.Vcs.Ignore_file;
        }
        if (value2 == JsonSchemaStatusPopup.STOP_IGNORE_FILE) {
            return AllIcons.Actions.AddFile;
        }
        return EMPTY_ICON;
    }

    @Nullable
    public ListSeparator getSeparatorAbove(JsonSchemaInfo value2) {
        List values2 = this.getValues();
        int index = values2.indexOf(value2);
        if (index - 1 >= 0) {
            JsonSchemaInfo info = (JsonSchemaInfo)values2.get(index - 1);
            if (info == JsonSchemaStatusPopup.EDIT_MAPPINGS || info == JsonSchemaStatusPopup.ADD_MAPPING) {
                return new ListSeparator(JsonBundle.message("schema.widget.registered.schemas", new Object[0]));
            }
            if (value2.getProvider() == null && info.getProvider() != null) {
                return new ListSeparator(JsonBundle.message("schema.widget.store.schemas", new Object[0]));
            }
        }
        return null;
    }

    public PopupStep onChosen(JsonSchemaInfo selectedValue, boolean finalChoice) {
        if (finalChoice) {
            if (selectedValue == JsonSchemaStatusPopup.EDIT_MAPPINGS || selectedValue == JsonSchemaStatusPopup.ADD_MAPPING) {
                return this.doFinalStep(() -> this.runSchemaEditorForCurrentFile());
            }
            if (selectedValue == JsonSchemaStatusPopup.LOAD_REMOTE) {
                return this.doFinalStep(() -> this.myService.triggerUpdateRemote());
            }
            if (selectedValue == JsonSchemaStatusPopup.IGNORE_FILE) {
                JsonSchemaInfoPopupStep.markIgnored(this.myVirtualFile, this.myProject);
                return this.doFinalStep(() -> this.myService.reset());
            }
            if (selectedValue == JsonSchemaStatusPopup.STOP_IGNORE_FILE) {
                JsonSchemaInfoPopupStep.unmarkIgnored(this.myVirtualFile, this.myProject);
                return this.doFinalStep(() -> this.myService.reset());
            }
            this.setMapping(selectedValue, this.myVirtualFile, this.myProject);
            return this.doFinalStep(() -> this.myService.reset());
        }
        return PopupStep.FINAL_CHOICE;
    }

    protected void runSchemaEditorForCurrentFile() {
        assert (this.myVirtualFile != null) : "override this method to do without a virtual file!";
        ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, JsonSchemaMappingsConfigurable.class, configurable -> configurable.setInitializer(() -> {
            JsonSchemaMappingsProjectConfiguration mappings = JsonSchemaMappingsProjectConfiguration.getInstance(this.myProject);
            UserDefinedJsonSchemaConfiguration configuration = mappings.findMappingForFile(this.myVirtualFile);
            if (configuration == null) {
                configuration = configurable.addProjectSchema();
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)this.myVirtualFile, (VirtualFile)this.myProject.getBaseDir());
                configuration.patterns.add(new UserDefinedJsonSchemaConfiguration.Item(relativePath == null ? this.myVirtualFile.getUrl() : relativePath, false, false));
            }
            configurable.selectInTree(configuration);
        }));
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    @Nullable
    @NlsContexts.Tooltip
    public String getTooltipTextFor(JsonSchemaInfo value2) {
        return JsonSchemaInfoPopupStep.getDoc(value2);
    }

    @Nullable
    @NlsContexts.Tooltip
    private static String getDoc(JsonSchemaInfo schema) {
        if (schema == null) {
            return null;
        }
        if (schema.getName() == null) {
            return schema.getDocumentation();
        }
        if (schema.getDocumentation() == null) {
            return schema.getName();
        }
        return new HtmlBuilder().append((HtmlChunk)HtmlChunk.tag((String)"b").addText(schema.getName())).append((HtmlChunk)HtmlChunk.br()).appendRaw(schema.getDocumentation()).toString();
    }

    public void setEmptyText(@NotNull StatusText emptyText) {
        if (emptyText == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(4);
        }
    }

    private static void markIgnored(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        if (project2 == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(5);
        }
        JsonSchemaMappingsProjectConfiguration configuration = JsonSchemaMappingsProjectConfiguration.getInstance(project2);
        configuration.markAsIgnored(virtualFile);
    }

    private static void unmarkIgnored(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        JsonSchemaMappingsProjectConfiguration configuration;
        if (project2 == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(6);
        }
        if (!(configuration = JsonSchemaMappingsProjectConfiguration.getInstance(project2)).isIgnoredFile(virtualFile)) {
            return;
        }
        configuration.unmarkAsIgnored(virtualFile);
    }

    protected void setMapping(@Nullable JsonSchemaInfo selectedValue, @Nullable VirtualFile virtualFile, @NotNull Project project2) {
        String path2;
        if (project2 == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(7);
        }
        assert (virtualFile != null) : "override this method to do without a virtual file!";
        JsonSchemaMappingsProjectConfiguration configuration = JsonSchemaMappingsProjectConfiguration.getInstance(project2);
        VirtualFile projectBaseDir = project2.getBaseDir();
        UserDefinedJsonSchemaConfiguration mappingForFile = configuration.findMappingForFile(virtualFile);
        if (mappingForFile != null) {
            for (UserDefinedJsonSchemaConfiguration.Item pattern2 : mappingForFile.patterns) {
                if (!Objects.equals(VfsUtil.findRelativeFile((VirtualFile)projectBaseDir, (String[])pattern2.getPathParts()), virtualFile) && !virtualFile.getUrl().equals(UserDefinedJsonSchemaConfiguration.Item.neutralizePath(pattern2.getPath()))) continue;
                mappingForFile.patterns.remove(pattern2);
                if (mappingForFile.patterns.size() == 0 && mappingForFile.isApplicationDefined()) {
                    configuration.removeConfiguration(mappingForFile);
                    break;
                }
                mappingForFile.refreshPatterns();
                break;
            }
        }
        if (selectedValue == null) {
            return;
        }
        String string2 = path2 = projectBaseDir == null ? null : VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)projectBaseDir);
        if (path2 == null) {
            path2 = virtualFile.getUrl();
        }
        UserDefinedJsonSchemaConfiguration existing = configuration.findMappingBySchemaInfo(selectedValue);
        UserDefinedJsonSchemaConfiguration.Item item2 = new UserDefinedJsonSchemaConfiguration.Item(path2, false, false);
        if (existing != null) {
            if (!existing.patterns.contains(item2)) {
                existing.patterns.add(item2);
                existing.refreshPatterns();
            }
        } else {
            configuration.addConfiguration(new UserDefinedJsonSchemaConfiguration(selectedValue.getDescription(), selectedValue.getSchemaVersion(), selectedValue.getUrl(project2), true, Collections.singletonList(item2)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSchemas";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/widget/JsonSchemaInfoPopupStep";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/widget/JsonSchemaInfoPopupStep";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markIgnored";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unmarkIgnored";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMapping";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }
}

