/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.input.dtd;

import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.input.InputFormat;
import com.thaiopensource.relaxng.input.dtd.Converter;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.translate.util.AbsoluteUriParam;
import com.thaiopensource.relaxng.translate.util.AbstractParam;
import com.thaiopensource.relaxng.translate.util.InvalidParamValueException;
import com.thaiopensource.relaxng.translate.util.InvalidParamsException;
import com.thaiopensource.relaxng.translate.util.NCNameParam;
import com.thaiopensource.relaxng.translate.util.NmtokenParam;
import com.thaiopensource.relaxng.translate.util.Param;
import com.thaiopensource.relaxng.translate.util.ParamFactory;
import com.thaiopensource.relaxng.translate.util.ParamProcessor;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.xml.dtd.app.UriEntityManager;
import com.thaiopensource.xml.dtd.om.Dtd;
import com.thaiopensource.xml.dtd.parse.DtdParserImpl;
import com.thaiopensource.xml.dtd.parse.ParseException;
import com.thaiopensource.xml.em.EntityManager;
import com.thaiopensource.xml.util.Naming;
import java.io.IOException;
import java.util.Map;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DtdInputFormat
implements InputFormat {
    static /* synthetic */ Class class$com$thaiopensource$relaxng$input$dtd$DtdInputFormat;

    public SchemaCollection load(String string2, String[] stringArray, String string3, ErrorHandler errorHandler2) throws InvalidParamsException, IOException, SAXException {
        ErrorReporter errorReporter = new ErrorReporter(errorHandler2, class$com$thaiopensource$relaxng$input$dtd$DtdInputFormat == null ? (class$com$thaiopensource$relaxng$input$dtd$DtdInputFormat = DtdInputFormat.class$("com.thaiopensource.relaxng.input.dtd.DtdInputFormat")) : class$com$thaiopensource$relaxng$input$dtd$DtdInputFormat);
        final Converter.Options options = new Converter.Options();
        if ("xsd".equals(string3)) {
            options.inlineAttlistDecls = true;
            options.generateStart = false;
        }
        ParamProcessor paramProcessor = new ParamProcessor();
        paramProcessor.declare("inline-attlist", new AbstractParam(){

            public void set(boolean bl) {
                options.inlineAttlistDecls = bl;
            }
        });
        paramProcessor.declare("xmlns", new AbsoluteUriParam(){

            public void set(String string2) throws InvalidParamValueException {
                if (string2.equals("")) {
                    this.setAbsoluteUri(string2);
                } else {
                    super.set(string2);
                }
            }

            protected void setAbsoluteUri(String string2) {
                options.defaultNamespace = string2;
            }
        });
        paramProcessor.declare("any-name", new NCNameParam(){

            protected void setNCName(String string2) {
                options.anyName = string2;
            }
        });
        paramProcessor.declare("strict-any", new AbstractParam(){

            public void set(boolean bl) {
                options.strictAny = bl;
            }
        });
        paramProcessor.declare("annotation-prefix", new NCNameParam(){

            protected void setNCName(String string2) {
                options.annotationPrefix = string2;
            }
        });
        paramProcessor.declare("colon-replacement", new NmtokenParam(){

            protected void setNmtoken(String string2) {
                options.colonReplacement = string2;
            }
        });
        paramProcessor.declare("generate-start", new AbstractParam(){

            public void set(boolean bl) {
                options.generateStart = bl;
            }
        });
        paramProcessor.declare("element-define", new DeclPatternParam(errorReporter.getLocalizer()){

            void setDeclPattern(String string2) {
                options.elementDeclPattern = string2;
            }
        });
        paramProcessor.declare("attlist-define", new DeclPatternParam(errorReporter.getLocalizer()){

            void setDeclPattern(String string2) {
                options.attlistDeclPattern = string2;
            }
        });
        paramProcessor.setParamFactory(new NamespaceDeclParamFactory(options.prefixMap));
        paramProcessor.process(stringArray, errorHandler2);
        try {
            Dtd dtd = new DtdParserImpl().parse(string2, (EntityManager)new UriEntityManager());
            try {
                return new Converter(dtd, errorReporter, options).convert();
            }
            catch (ErrorReporter.WrappedSAXException wrappedSAXException) {
                throw wrappedSAXException.getException();
            }
        }
        catch (ParseException parseException) {
            throw new SAXParseException(parseException.getMessageBody(), null, parseException.getLocation(), parseException.getLineNumber(), parseException.getColumnNumber());
        }
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static abstract class DeclPatternParam
    extends AbstractParam {
        private final Localizer localizer;

        DeclPatternParam(Localizer localizer) {
            this.localizer = localizer;
        }

        public void set(String string2) throws InvalidParamValueException {
            if (string2.indexOf(37) < 0) {
                throw new InvalidParamValueException(this.localizer.message("no_percent"));
            }
            if (string2.lastIndexOf(37) != string2.indexOf(37)) {
                throw new InvalidParamValueException(this.localizer.message("multiple_percent"));
            }
            if (!Naming.isNcname(string2.replace('%', 'x'))) {
                throw new InvalidParamValueException(this.localizer.message("not_ncname_with_percent"));
            }
            this.setDeclPattern(string2);
        }

        abstract void setDeclPattern(String var1);
    }

    private static class NamespaceDeclParamFactory
    implements ParamFactory {
        private final Map prefixMap;

        NamespaceDeclParamFactory(Map map2) {
            this.prefixMap = map2;
        }

        public Param createParam(String string2) {
            if (!string2.startsWith("xmlns:")) {
                return null;
            }
            String string3 = string2.substring(6);
            if (!Naming.isNcname(string3)) {
                return null;
            }
            return new AbsoluteUriParam(this, string3){
                private final /* synthetic */ String val$prefix;
                private final /* synthetic */ NamespaceDeclParamFactory this$0;
                {
                    this.this$0 = namespaceDeclParamFactory;
                    this.val$prefix = string2;
                }

                public void setAbsoluteUri(String string2) {
                    NamespaceDeclParamFactory.access$000(this.this$0).put(this.val$prefix, string2);
                }
            };
        }

        static /* synthetic */ Map access$000(NamespaceDeclParamFactory namespaceDeclParamFactory) {
            return namespaceDeclParamFactory.prefixMap;
        }
    }
}

