/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output;

import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.xml.out.CharRepertoire;
import com.thaiopensource.xml.util.EncodingMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;

public class LocalOutputDirectory
implements OutputDirectory {
    private final File mainOutputFile;
    private final String lineSeparator;
    private final String outputExtension;
    private String defaultEncoding;
    private boolean alwaysUseDefaultEncoding;
    private final int lineLength;
    private final Map uriMap = new HashMap();
    private final String mainInputExtension;
    private int indent;

    public LocalOutputDirectory(String string2, File file, String string3, String string4, int n, int n2) {
        this.mainOutputFile = file;
        this.outputExtension = string3;
        this.defaultEncoding = string4;
        this.lineSeparator = System.getProperty("line.separator");
        this.lineLength = n;
        this.indent = n2;
        this.uriMap.put(string2, file.getName());
        int n3 = string2.lastIndexOf(47);
        int n4 = string2.lastIndexOf(46);
        this.mainInputExtension = n4 > 0 && n4 > n3 ? string2.substring(n4) : "";
    }

    public void setEncoding(String string2) {
        this.defaultEncoding = string2;
        this.alwaysUseDefaultEncoding = true;
    }

    public OutputDirectory.Stream open(String string2, String string3) throws IOException {
        if (string3 == null || this.alwaysUseDefaultEncoding) {
            string3 = this.defaultEncoding;
        }
        String string4 = EncodingMap.getJavaName(string3);
        File file = new File(this.mainOutputFile.getParentFile(), this.mapFilename(string2));
        return new OutputDirectory.Stream(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), string4), string3, CharRepertoire.getInstance(string4));
    }

    public String reference(String string2, String string3) {
        return this.mapFilename(string3);
    }

    private String mapFilename(String string2) {
        String string3 = (String)this.uriMap.get(string2);
        if (string3 == null) {
            string3 = this.chooseFilename(string2);
            this.uriMap.put(string2, string3);
        }
        return string3;
    }

    private String chooseFilename(String string2) {
        String string3 = string2.substring(string2.lastIndexOf(47) + 1);
        String string4 = string3.endsWith(this.mainInputExtension) ? string3.substring(0, string3.length() - this.mainInputExtension.length()) : string3;
        string3 = string4 + this.outputExtension;
        int n = 1;
        while (this.uriMap.containsValue(string3)) {
            string3 = string4 + Integer.toString(n) + this.outputExtension;
            ++n;
        }
        return string3;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int n) {
        this.indent = n;
    }
}

