/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpClassElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpPosixBracketExpression;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;

public class RegExpRedundantClassElementInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RegExpRedundantClassElementInspection.$$$reportNull$$$0(0);
        }
        return new RegExpElementVisitor(){

            @Override
            public void visitRegExpClass(RegExpClass regExpClass) {
                RegExpClass regExp = (RegExpClass)ObjectUtils.tryCast((Object)regExpClass, RegExpClass.class);
                if (regExp == null) {
                    return;
                }
                Object[] classElements = regExp.getElements();
                boolean containsNonWordCharacterClass = ContainerUtil.exists((Object[])classElements, RegExpRedundantClassElementInspection::isAnyNonWordCharacter);
                boolean containsWordCharacterClass = ContainerUtil.exists((Object[])classElements, RegExpRedundantClassElementInspection::isAnyWordCharacter);
                for (Object element : classElements) {
                    if ((!containsWordCharacterClass || !RegExpRedundantClassElementInspection.isAnyDigit((RegExpClassElement)element)) && (!containsNonWordCharacterClass || !RegExpRedundantClassElementInspection.isAnyNonDigit((RegExpClassElement)element))) continue;
                    String elementText = element.getText();
                    holder.registerProblem((PsiElement)element, RegExpBundle.message("inspection.warning.redundant.class.element", elementText), new LocalQuickFix[]{new RemoveRedundantClassElement(elementText)});
                }
            }
        };
    }

    private static boolean isAnyDigit(RegExpClassElement classElement) {
        if (classElement instanceof RegExpSimpleClass) {
            return ((RegExpSimpleClass)classElement).getKind().equals((Object)RegExpSimpleClass.Kind.DIGIT);
        }
        if (classElement instanceof RegExpPosixBracketExpression) {
            String className = ((RegExpPosixBracketExpression)classElement).getClassName();
            return className != null && className.equals("digit");
        }
        return false;
    }

    private static boolean isAnyNonDigit(RegExpClassElement classElement) {
        return classElement instanceof RegExpSimpleClass && ((RegExpSimpleClass)classElement).getKind().equals((Object)RegExpSimpleClass.Kind.NON_DIGIT);
    }

    private static boolean isAnyWordCharacter(RegExpClassElement classElement) {
        if (classElement instanceof RegExpSimpleClass) {
            return ((RegExpSimpleClass)classElement).getKind().equals((Object)RegExpSimpleClass.Kind.WORD);
        }
        if (classElement instanceof RegExpPosixBracketExpression) {
            String className = ((RegExpPosixBracketExpression)classElement).getClassName();
            return className != null && className.equals("word");
        }
        return false;
    }

    private static boolean isAnyNonWordCharacter(RegExpClassElement classElement) {
        return classElement instanceof RegExpSimpleClass && ((RegExpSimpleClass)classElement).getKind().equals((Object)RegExpSimpleClass.Kind.NON_WORD);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/RegExpRedundantClassElementInspection", "buildVisitor"));
    }

    private static class RemoveRedundantClassElement
    implements LocalQuickFix {
        private final String myClassElementText;

        private RemoveRedundantClassElement(String text2) {
            this.myClassElementText = text2;
        }

        @NotNull
        public String getFamilyName() {
            String string2 = RegExpBundle.message("inspection.quick.fix.remove.redundant.class.element", new Object[0]);
            if (string2 == null) {
                RemoveRedundantClassElement.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @NotNull
        public String getName() {
            String string2 = RegExpBundle.message("inspection.quick.fix.remove.redundant.0.class.element", this.myClassElementText);
            if (string2 == null) {
                RemoveRedundantClassElement.$$$reportNull$$$0(1);
            }
            return string2;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project2 == null) {
                RemoveRedundantClassElement.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RemoveRedundantClassElement.$$$reportNull$$$0(3);
            }
            if ((element = descriptor.getPsiElement()) == null) {
                return;
            }
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/RegExpRedundantClassElementInspection$RemoveRedundantClassElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/RegExpRedundantClassElementInspection$RemoveRedundantClassElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 2, 3 -> new IllegalArgumentException(string2);
            };
        }
    }
}

