/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.resolve;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomManager;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.xml.dom.RngGrammar;
import org.jetbrains.annotations.NotNull;

public final class RelaxIncludeIndex {
    public static boolean processForwardDependencies(XmlFile file, PsiElementProcessor<? super XmlFile> processor2) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return processor2.execute((PsiElement)file);
        }
        Project project2 = file.getProject();
        VirtualFile[] files2 = FileIncludeManager.getManager((Project)project2).getIncludedFiles(virtualFile, true);
        return RelaxIncludeIndex.processRelatedFiles(file, files2, processor2);
    }

    public static boolean processBackwardDependencies(@NotNull XmlFile file, PsiElementProcessor<? super XmlFile> processor2) {
        VirtualFile virtualFile;
        if (file == null) {
            RelaxIncludeIndex.$$$reportNull$$$0(0);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            return processor2.execute((PsiElement)file);
        }
        Project project2 = file.getProject();
        VirtualFile[] files2 = FileIncludeManager.getManager((Project)project2).getIncludingFiles(virtualFile, true);
        return RelaxIncludeIndex.processRelatedFiles(file, files2, processor2);
    }

    private static boolean processRelatedFiles(PsiFile file, VirtualFile[] files2, PsiElementProcessor<? super XmlFile> processor2) {
        PsiFile[] psiFiles;
        Project project2 = file.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        for (PsiFile psiFile2 : psiFiles = (PsiFile[])ContainerUtil.map2Array((Object[])files2, PsiFile.class, (Function)((NullableFunction)file1 -> psiManager.findFile(file1)))) {
            if (RelaxIncludeIndex.processFile(psiFile2, processor2)) continue;
            return false;
        }
        return true;
    }

    private static boolean processFile(PsiFile psiFile2, PsiElementProcessor<? super XmlFile> processor2) {
        FileType type2 = psiFile2.getFileType();
        return !(type2 == XmlFileType.INSTANCE && RelaxIncludeIndex.isRngFile(psiFile2) ? !processor2.execute((PsiElement)((XmlFile)psiFile2)) : type2 == RncFileType.getInstance() && !processor2.execute((PsiElement)((XmlFile)psiFile2)));
    }

    static boolean isRngFile(PsiFile psiFile2) {
        return psiFile2 instanceof XmlFile && DomManager.getDomManager(psiFile2.getProject()).getFileElement((XmlFile)psiFile2, RngGrammar.class) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/relaxNG/model/resolve/RelaxIncludeIndex", "processBackwardDependencies"));
    }
}

