/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.classFilter;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.ClassFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.AnnotationIgnoredMethodFilter;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class KotlinCompanionInIgnoredClassFilter
extends ClassFilter {
    private static final String COMPANION_SUFFIX = "$Companion";
    private static final String IGNORED_CLASS_MARKER = "__$$IGNORED_CLASS_MARKER$$__";
    private static final String IGNORED_CLASS_MARKER_DESC = "";
    private boolean myShouldIgnore;
    private boolean myVisitedMethod;

    public boolean isApplicable(Instrumenter context) {
        return AnnotationIgnoredMethodFilter.hasIgnoreAnnotations(context);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        String className = this.myContext.getClassName();
        if (className.endsWith(COMPANION_SUFFIX)) {
            String outerName = className.substring(0, className.length() - COMPANION_SUFFIX.length());
            if (this.myContext.getProjectData().isMethodIgnored(outerName, IGNORED_CLASS_MARKER, IGNORED_CLASS_MARKER_DESC)) {
                this.myShouldIgnore = true;
                this.myContext.setIgnoreSection(true);
            }
        }
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (!this.myVisitedMethod) {
            this.myVisitedMethod = true;
            String className = this.myContext.getClassName();
            if (this.myContext.isClassIgnoredByAnnotation()) {
                this.myContext.getProjectData().addIgnoredMethod(className, IGNORED_CLASS_MARKER, IGNORED_CLASS_MARKER_DESC);
            }
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.myShouldIgnore) {
            this.myContext.setIgnoreSection(false);
        }
    }
}

