/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.testTracking;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.dataAccess.CoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingClassDataInstrumenter;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingMode;
import com.intellij.rt.coverage.util.TestTrackingCallback;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;

public class TestTrackingClassDataMode
implements TestTrackingMode {
    public TestTrackingCallback createTestTrackingCallback() {
        return new TestTrackingCallback(){

            public void clearTrace(ClassData classData) {
                classData.setTraceMask(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean[] traceLine(ClassData classData, int line) {
                boolean[] linesTrace = classData.getTraceMask();
                boolean[] result = null;
                if (linesTrace == null) {
                    ClassData classData2 = classData;
                    synchronized (classData2) {
                        linesTrace = classData.getTraceMask();
                        if (linesTrace == null) {
                            linesTrace = new boolean[classData.getLines().length];
                            classData.setTraceMask(linesTrace);
                            result = linesTrace;
                        }
                    }
                }
                linesTrace[line] = true;
                return result;
            }
        };
    }

    public Instrumenter createInstrumenter(ProjectData projectData, ClassVisitor classVisitor, ClassReader cr, String className, boolean shouldSaveSource, CoverageDataAccess dataAccess) {
        return new TestTrackingClassDataInstrumenter(projectData, classVisitor, cr, className, shouldSaveSource, dataAccess);
    }
}

