/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNameUtil {
    public static final String CLASS_FILE_SUFFIX = ".class";

    public static String getOuterClassName(String className) {
        int idx = className.indexOf(36);
        if (idx == -1) {
            return className;
        }
        return className.substring(0, idx);
    }

    public static boolean matchesPatterns(String className, List<Pattern> patterns) {
        for (Pattern excludePattern : patterns) {
            if (!excludePattern.matcher(className).matches()) continue;
            return true;
        }
        return false;
    }

    public static String convertToFQName(String className) {
        return className.replace('\\', '.').replace('/', '.');
    }

    public static String convertToInternalName(String className) {
        return className.replace('.', '/');
    }

    public static String convertVMNameToFQN(String className) {
        if (className.startsWith("L") && className.endsWith(";")) {
            className = className.substring(1, className.length() - 1);
        }
        return ClassNameUtil.convertToFQName(className);
    }

    public static String removeClassSuffix(String name) {
        if (name.endsWith(CLASS_FILE_SUFFIX)) {
            return name.substring(0, name.length() - CLASS_FILE_SUFFIX.length());
        }
        return name;
    }
}

