/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/ant/AntSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.ant"})
public final class AntSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("build.ant.state", 2, null, 4, null);
    @NotNull
    private static final EventId1<Boolean> HAS_ANT_PROJECTS = GROUP.registerEvent("hasAntProjects", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> IS_RUN_IN_BACKGROUND = GROUP.registerEvent("isRunInBackground", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> IS_COLORED_OUTPUT_MESSAGES = GROUP.registerEvent("isColoredOutputMessages", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> IS_VIEW_CLOSED_WHEN_NO_ERRORS = GROUP.registerEvent("isViewClosedWhenNoErrors", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> IS_COLLAPSE_FINISHED_TARGETS = GROUP.registerEvent("isCollapseFinishedTargets", (EventField)EventFields.Enabled);

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<AntBuildFileBase> buildFiles = AntConfiguration.getInstance(project).getBuildFileList();
        if (buildFiles.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set usages = new LinkedHashSet();
        usages.add(HAS_ANT_PROJECTS.metric((Object)true));
        for (AntBuildFileBase each : buildFiles) {
            usages.add(IS_RUN_IN_BACKGROUND.metric((Object)each.isRunInBackground()));
            usages.add(IS_COLORED_OUTPUT_MESSAGES.metric((Object)each.isColoredOutputMessages()));
            usages.add(IS_VIEW_CLOSED_WHEN_NO_ERRORS.metric((Object)each.isViewClosedWhenNoErrors()));
            usages.add(IS_COLLAPSE_FINISHED_TARGETS.metric((Object)each.isCollapseFinishedTargets()));
        }
        return usages;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/lang/ant/AntSettingsCollector$Companion;", "", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "HAS_ANT_PROJECTS", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "IS_COLLAPSE_FINISHED_TARGETS", "IS_COLORED_OUTPUT_MESSAGES", "IS_RUN_IN_BACKGROUND", "IS_VIEW_CLOSED_WHEN_NO_ERRORS", "intellij.ant"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

