/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.impl.AntBuildTargetImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.KeymapGroupFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import java.util.HashMap;
import java.util.List;

final class AntKeymapExtension
implements KeymapExtension {
    AntKeymapExtension() {
    }

    public KeymapGroup createGroup(Condition<? super AnAction> filtered, Project project) {
        KeymapGroup result = KeymapGroupFactory.getInstance().createGroup(AntBundle.message("ant.targets.group.title", new Object[0]), AllIcons.Nodes.KeymapAnt);
        if (project != null) {
            HashMap<String, KeymapGroup> buildFileNameToGroup = new HashMap<String, KeymapGroup>();
            ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
            String actionIdPrefix = AntConfiguration.getActionIdPrefix(project);
            List ids = actionManager.getActionIdList(actionIdPrefix);
            ids.sort(null);
            for (String id : ids) {
                String buildFileName;
                if (filtered != null && !filtered.value((Object)actionManager.getActionOrStub(id)) || (buildFileName = AntBuildTargetImpl.parseBuildFileName(project, id)) == null) continue;
                KeymapGroup subGroup = (KeymapGroup)buildFileNameToGroup.get(buildFileName);
                if (subGroup == null) {
                    subGroup = KeymapGroupFactory.getInstance().createGroup(buildFileName);
                    buildFileNameToGroup.put(buildFileName, subGroup);
                    result.addGroup(subGroup);
                }
                subGroup.addActionId(id);
            }
        }
        return result;
    }
}

