/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.PostCommitChangeConverter;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.log.Hash;
import git4idea.GitCommit;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitLogUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0016\u0010\r\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgit4idea/checkin/GitPostCommitChangeConverter;", "Lcom/intellij/openapi/vcs/checkin/PostCommitChangeConverter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "areConsequentCommits", "", "commitContexts", "", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "collectChangesAfterCommit", "Lcom/intellij/openapi/vcs/changes/Change;", "commitContext", "isFailureUpToDate", "loadChangesFromCommit", "repo", "Lgit4idea/repo/GitRepository;", "hash", "Lcom/intellij/vcs/log/Hash;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitPostCommitChangeConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitPostCommitChangeConverter.kt\ngit4idea/checkin/GitPostCommitChangeConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,90:1\n1549#2:91\n1620#2,3:92\n1726#2,3:95\n1747#2,3:98\n1747#2,3:102\n10#3:101\n*S KotlinDebug\n*F\n+ 1 GitPostCommitChangeConverter.kt\ngit4idea/checkin/GitPostCommitChangeConverter\n*L\n44#1:91\n44#1:92,3\n45#1:95,3\n46#1:98,3\n66#1:102,3\n55#1:101\n*E\n"})
public final class GitPostCommitChangeConverter
implements PostCommitChangeConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Key<Map<GitRepository, Hash>> GIT_POST_COMMIT_HASHES_KEY;
    @NotNull
    private static final ReadWriteProperty<? super CommitContext, Map<GitRepository, Hash>> postCommitHashes$delegate;

    public GitPostCommitChangeConverter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public List<Change> collectChangesAfterCommit(@NotNull CommitContext commitContext) {
        Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
        Map map2 = GitPostCommitChangeConverter.Companion.getPostCommitHashes(commitContext);
        if (map2 == null) {
            return CollectionsKt.emptyList();
        }
        Map hashes2 = map2;
        List result2 = new ArrayList();
        for (Map.Entry entry : hashes2.entrySet()) {
            GitRepository repo = (GitRepository)entry.getKey();
            Hash hash = (Hash)entry.getValue();
            CollectionsKt.addAll((Collection)result2, (Iterable)this.loadChangesFromCommit(repo, hash));
        }
        return result2;
    }

    private final List<Change> loadChangesFromCommit(GitRepository repo, Hash hash) {
        CollectConsumer consumer2 = new CollectConsumer();
        GitCommitRequirements commitRequirements = new GitCommitRequirements(false, null, GitCommitRequirements.DiffInMergeCommits.FIRST_PARENT, 3, null);
        GitLogUtil.readFullDetailsForHashes(this.project, repo.getRoot(), CollectionsKt.listOf((Object)hash.asString()), commitRequirements, (Consumer<? super GitCommit>)((Consumer)consumer2));
        Collection collection = consumer2.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"consumer.result");
        GitCommit gitCommit = (GitCommit)((Object)CollectionsKt.firstOrNull((Iterable)collection));
        if (gitCommit == null) {
            Object[] objectArray = new Object[]{repo.getRoot().getName(), hash.asString()};
            throw new VcsException(GitBundle.message("post.commit.check.load.changes.error", objectArray));
        }
        GitCommit commit = gitCommit;
        Collection collection2 = commit.getChanges(0);
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"commit.getChanges(0)");
        return CollectionsKt.toList((Iterable)collection2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean areConsequentCommits(@NotNull List<CommitContext> commitContexts) {
        boolean bl;
        List commitHashes;
        block12: {
            boolean bl2;
            block11: {
                Iterator $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(commitContexts, (String)"commitContexts");
                Iterable $this$map$iv = commitContexts;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv = iterator.next();
                    CommitContext commitContext = (CommitContext)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(GitPostCommitChangeConverter.Companion.getPostCommitHashes((CommitContext)it));
                }
                commitHashes = (List)destination$iv$iv;
                Iterable $this$all$iv = commitHashes;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Map it = (Map)element$iv;
                        boolean bl4 = false;
                        if (it == null) continue;
                        bl2 = false;
                        break block11;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return true;
            }
            Iterable $this$any$iv = commitHashes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Map it = (Map)element$iv;
                    boolean bl5 = false;
                    if (!(it == null)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        Map repoMap = new LinkedHashMap();
        Iterator iterator = CollectionsKt.reversed((Iterable)commitHashes).iterator();
        while (iterator.hasNext()) {
            Map hashes2;
            Map map2 = hashes2 = (Map)iterator.next();
            Intrinsics.checkNotNull((Object)map2);
            for (Map.Entry entry : map2.entrySet()) {
                Hash parentHash;
                Hash hash;
                GitRepository repo = (GitRepository)entry.getKey();
                Hash oldHash = repoMap.put(repo, hash = (Hash)entry.getValue());
                if (oldHash == null || Intrinsics.areEqual((Object)(parentHash = Git.getInstance().resolveReference(repo, oldHash + "^1")), (Object)hash)) continue;
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GitPostCommitChangeConverter.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.debug("Non-consequent commits: " + oldHash + " - " + hash);
                return false;
            }
        }
        return true;
    }

    public boolean isFailureUpToDate(@NotNull List<CommitContext> commitContexts) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(commitContexts, (String)"commitContexts");
            Object object = (CommitContext)CollectionsKt.lastOrNull(commitContexts);
            if (object == null || (object = GitPostCommitChangeConverter.Companion.getPostCommitHashes((CommitContext)object)) == null) {
                return true;
            }
            Object lastCommit = object;
            Iterable $this$any$iv = lastCommit.entrySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    GitRepository repo = (GitRepository)entry.getKey();
                    Hash hash = (Hash)entry.getValue();
                    if (!Intrinsics.areEqual((Object)repo.getCurrentRevision(), (Object)hash.asString())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmStatic
    public static final void markRepositoryCommit(@NotNull CommitContext commitContext, @NotNull GitRepository repository) {
        Companion.markRepositoryCommit(commitContext, repository);
    }

    static {
        Key key = Key.create((String)"Git.Post.Commit.Hash");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<MutableMap<GitRep\u2026>(\"Git.Post.Commit.Hash\")");
        GIT_POST_COMMIT_HASHES_KEY = key;
        postCommitHashes$delegate = AbstractCommitWorkflowKt.commitExecutorProperty(GIT_POST_COMMIT_HASHES_KEY, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0006H\u0007R9\u0010\u0003\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007 \b*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000RK\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005*\u00020\f2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00058B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lgit4idea/checkin/GitPostCommitChangeConverter$Companion;", "", "()V", "GIT_POST_COMMIT_HASHES_KEY", "Lcom/intellij/openapi/util/Key;", "", "Lgit4idea/repo/GitRepository;", "Lcom/intellij/vcs/log/Hash;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "<set-?>", "postCommitHashes", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "getPostCommitHashes", "(Lcom/intellij/openapi/vcs/changes/CommitContext;)Ljava/util/Map;", "setPostCommitHashes", "(Lcom/intellij/openapi/vcs/changes/CommitContext;Ljava/util/Map;)V", "postCommitHashes$delegate", "Lkotlin/properties/ReadWriteProperty;", "markRepositoryCommit", "", "commitContext", "repository", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitPostCommitChangeConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitPostCommitChangeConverter.kt\ngit4idea/checkin/GitPostCommitChangeConverter$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,90:1\n10#2:91\n*S KotlinDebug\n*F\n+ 1 GitPostCommitChangeConverter.kt\ngit4idea/checkin/GitPostCommitChangeConverter$Companion\n*L\n86#1:91\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final Map<GitRepository, Hash> getPostCommitHashes(CommitContext $this$postCommitHashes) {
            return (Map)postCommitHashes$delegate.getValue((Object)$this$postCommitHashes, $$delegatedProperties[0]);
        }

        private final void setPostCommitHashes(CommitContext $this$postCommitHashes, Map<GitRepository, Hash> map2) {
            postCommitHashes$delegate.setValue((Object)$this$postCommitHashes, $$delegatedProperties[0], map2);
        }

        @JvmStatic
        public final void markRepositoryCommit(@NotNull CommitContext commitContext, @NotNull GitRepository repository) {
            Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Map hashes2 = this.getPostCommitHashes(commitContext);
            if (hashes2 == null) {
                hashes2 = new LinkedHashMap();
                this.setPostCommitHashes(commitContext, hashes2);
            }
            Hash hash = GitUtil.getHead(repository);
            if (hash == null) {
                return;
            }
            Hash head = hash;
            Hash oldHead = hashes2.put(repository, head);
            if (oldHead != null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GitPostCommitChangeConverter.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.warn("Multiple commits found for " + repository + ": " + head + " - " + oldHead);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl(Companion.class, "postCommitHashes", "getPostCommitHashes(Lcom/intellij/openapi/vcs/changes/CommitContext;)Ljava/util/Map;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

