/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ignore.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import git4idea.GitUtil;
import git4idea.ignore.lang.GitExcludeFileType;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B5\u0012\u0016\u0010\u0002\u001a\u0012\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u00a2\u0006\u0002\b\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lgit4idea/ignore/actions/DefaultGitExcludeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "dynamicText", "Ljava/util/function/Supplier;", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "dynamicDescription", "(Ljava/util/function/Supplier;Ljava/util/function/Supplier;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isEnabled", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "", "intellij.vcs.git"})
public abstract class DefaultGitExcludeAction
extends DumbAwareAction {
    public DefaultGitExcludeAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription) {
        Intrinsics.checkNotNullParameter(dynamicText, (String)"dynamicText");
        Intrinsics.checkNotNullParameter(dynamicDescription, (String)"dynamicDescription");
        super(dynamicText, dynamicDescription, GitExcludeFileType.INSTANCE.getIcon());
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean enabled = this.isEnabled(e);
        e.getPresentation().setVisible(enabled);
        e.getPresentation().setEnabled(enabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) return false;
        Collection<GitRepository> collection = GitUtil.getRepositories(project);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRepositories(project)");
        if (collection.isEmpty()) return false;
        return true;
    }
}

