/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.vfs.AsyncVfsEventsListener;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lgit4idea/repo/GitUntrackedDirtyScopeListener;", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "(Lgit4idea/repo/GitRepositoryManager;)V", "getRepositoryManager", "()Lgit4idea/repo/GitRepositoryManager;", "filesChanged", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "getAffectedFilePaths", "Lcom/intellij/openapi/vcs/FilePath;", "event", "intellij.vcs.git"})
public final class GitUntrackedDirtyScopeListener
implements AsyncVfsEventsListener {
    @NotNull
    private final GitRepositoryManager repositoryManager;

    public GitUntrackedDirtyScopeListener(@NotNull GitRepositoryManager repositoryManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)repositoryManager), (String)"repositoryManager");
        this.repositoryManager = repositoryManager;
    }

    @NotNull
    public final GitRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public void filesChanged(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (this.repositoryManager.getRepositories().isEmpty()) {
            return;
        }
        MultiMap map2 = new MultiMap();
        for (VFileEvent entry : events) {
            for (FilePath filePath : this.getAffectedFilePaths(entry)) {
                GitRepository repo;
                if ((GitRepository)this.repositoryManager.getRepositoryForFileQuick(filePath) == null) continue;
                map2.putValue((Object)repo, (Object)filePath);
            }
        }
        for (Map.Entry entry : map2.entrySet()) {
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"map.entrySet()");
            GitRepository repo = (GitRepository)entry.getKey();
            Collection filePaths = (Collection)entry.getValue();
            repo.getUntrackedFilesHolder().markPossiblyUntracked(filePaths);
        }
    }

    private final List<FilePath> getAffectedFilePaths(VFileEvent event) {
        boolean bl;
        if (event instanceof VFileContentChangeEvent) {
            return CollectionsKt.emptyList();
        }
        if (event instanceof VFilePropertyChangeEvent && !((VFilePropertyChangeEvent)event).isRename()) {
            return CollectionsKt.emptyList();
        }
        ArrayList<FilePath> affectedFilePaths = new ArrayList<FilePath>(2);
        if (event instanceof VFileCreateEvent) {
            bl = ((VFileCreateEvent)event).isDirectory();
        } else {
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNull((Object)virtualFile);
            bl = virtualFile.isDirectory();
        }
        boolean isDirectory = bl;
        affectedFilePaths.add(VcsUtil.getFilePath((String)event.getPath(), (boolean)isDirectory));
        if (event instanceof VFileMoveEvent) {
            affectedFilePaths.add(VcsUtil.getFilePath((String)((VFileMoveEvent)event).getOldPath(), (boolean)isDirectory));
        } else if (event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).isRename()) {
            affectedFilePaths.add(VcsUtil.getFilePath((String)((VFilePropertyChangeEvent)event).getOldPath(), (boolean)isDirectory));
        }
        return affectedFilePaths;
    }
}

