/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.toolbar;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.icons.AllIcons;
import com.intellij.icons.ExpUiIcons;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.ToolbarQuickActionInsertStrategiesKt;
import com.intellij.ide.ui.laf.darcula.ui.ToolbarComboWidgetUI;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.wm.impl.ExpandableComboAction;
import com.intellij.openapi.wm.impl.ToolbarComboWidget;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchPopup;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.ui.branch.popup.GitBranchesTreePopup;
import git4idea.ui.toolbar.GitToolbarActions;
import git4idea.ui.toolbar.GitToolbarWidgetActionKt;
import git4idea.ui.toolbar.MyRepoChanges;
import icons.DvcsImplIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000  2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0016J\u0018\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u001e\u001a\u00020\u0006*\u00020\rH\u0002J\f\u0010\u001f\u001a\u00020\t*\u00020\rH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lgit4idea/ui/toolbar/GitToolbarWidgetAction;", "Lcom/intellij/openapi/wm/impl/ExpandableComboAction;", "()V", "actionsWithIncomingOutgoingEnabled", "", "widgetIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "calcText", "", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lgit4idea/repo/GitRepository;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "createPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "updateCustomComponent", "component", "calcIcon", "calcTooltip", "Companion", "GitWidgetState", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitToolbarWidgetAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitToolbarWidgetAction.kt\ngit4idea/ui/toolbar/GitToolbarWidgetAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
public final class GitToolbarWidgetAction
extends ExpandableComboAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Icon widgetIcon;
    private final boolean actionsWithIncomingOutgoingEnabled;
    @NotNull
    private static final String GIT_WIDGET_PLACEHOLDER_KEY = "git-widget-placeholder";

    public GitToolbarWidgetAction() {
        Icon icon = ExpUiIcons.General.Vcs;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Vcs");
        this.widgetIcon = icon;
        this.actionsWithIncomingOutgoingEnabled = GitToolbarActions.INSTANCE.isEnabledAndVisible$intellij_vcs_git();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Nullable
    protected JBPopup createPopup(@NotNull AnActionEvent event) {
        JBPopup jBPopup;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        GitRepository repository = (GitRepository)event.getPresentation().getClientProperty(GitToolbarWidgetActionKt.access$getRepositoryKey$p());
        if (repository != null) {
            if (GitBranchesTreePopup.Companion.isEnabled()) {
                jBPopup = GitBranchesTreePopup.Companion.create(project2, repository);
            } else {
                ListPopup listPopup = GitBranchPopup.getInstance(project2, repository, event.getDataContext()).asListPopup();
                Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"getInstance(project, rep\u2026ataContext).asListPopup()");
                jBPopup = (JBPopup)listPopup;
            }
        } else {
            Companion.updatePlaceholder(project2, null);
            AnAction anAction = ActionManager.getInstance().getAction("Vcs.ToolbarWidget.CreateRepository");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            ActionGroup group = (ActionGroup)anAction;
            String string = ActionPlaces.getPopupPlace((String)"Vcs.Toolbar.Widget");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPopupPlace(ActionPlaces.VCS_TOOLBAR_WIDGET)");
            String place = string;
            ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, group, event.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, place);
            Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"{\n      updatePlaceholde\u2026EARCH, true, place)\n    }");
            jBPopup = (JBPopup)listPopup;
        }
        JBPopup popup2 = jBPopup;
        return popup2;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        JComponent comp;
        block0: {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            comp = super.createCustomComponent(presentation, place);
            ComponentUI componentUI = comp.getUI();
            ToolbarComboWidgetUI toolbarComboWidgetUI = componentUI instanceof ToolbarComboWidgetUI ? (ToolbarComboWidgetUI)componentUI : null;
            if (toolbarComboWidgetUI == null) break block0;
            toolbarComboWidgetUI.setMaxWidth(Integer.MAX_VALUE);
        }
        return comp;
    }

    /*
     * WARNING - void declaration
     */
    public void updateCustomComponent(@NotNull JComponent component2, @NotNull Presentation presentation) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        ToolbarComboWidget toolbarComboWidget = component2 instanceof ToolbarComboWidget ? (ToolbarComboWidget)component2 : null;
        if (toolbarComboWidget == null) {
            return;
        }
        ToolbarComboWidget widget = toolbarComboWidget;
        widget.setText(presentation.getText());
        widget.setToolTipText(presentation.getDescription());
        widget.setLeftIcons(CollectionsKt.listOfNotNull((Object)presentation.getIcon()));
        CustomActionsSchema schema = CustomActionsSchema.Companion.getInstance();
        boolean shouldShowIncoming = this.actionsWithIncomingOutgoingEnabled && !ToolbarQuickActionInsertStrategiesKt.groupContainsAction((String)"MainToolbarNewUI", (String)"main.toolbar.git.update.project", (CustomActionsSchema)schema);
        boolean shouldShowOutgoing = this.actionsWithIncomingOutgoingEnabled && !ToolbarQuickActionInsertStrategiesKt.groupContainsAction((String)"MainToolbarNewUI", (String)"main.toolbar.git.push", (CustomActionsSchema)schema);
        ToolbarComboWidget toolbarComboWidget2 = widget;
        MyRepoChanges myRepoChanges = (MyRepoChanges)presentation.getClientProperty(GitToolbarWidgetActionKt.access$getChangesKey$p());
        if (myRepoChanges != null) {
            void changes;
            MyRepoChanges myRepoChanges2 = myRepoChanges;
            ToolbarComboWidget toolbarComboWidget3 = toolbarComboWidget2;
            boolean bl = false;
            List res = new ArrayList();
            if (changes.getIncoming() && (!this.actionsWithIncomingOutgoingEnabled || shouldShowIncoming)) {
                Icon icon = DvcsImplIcons.Incoming;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Incoming");
                res.add(icon);
            }
            if (changes.getOutgoing() && (!this.actionsWithIncomingOutgoingEnabled || shouldShowOutgoing)) {
                Icon icon = DvcsImplIcons.Outgoing;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Outgoing");
                res.add(icon);
            }
            list2 = res;
            toolbarComboWidget2 = toolbarComboWidget3;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        toolbarComboWidget2.setRightIcons(list2);
    }

    public void update(@NotNull AnActionEvent e) {
        MyRepoChanges myRepoChanges;
        Object object;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GitRepository gitRepository = GitBranchUtil.guessWidgetRepository(project, e.getDataContext());
        GitWidgetState state2 = Companion.getWidgetState(project, gitRepository);
        e.getPresentation().putClientProperty(GitToolbarWidgetActionKt.access$getProjectKey$p(), (Object)project);
        if (gitRepository != null && !Intrinsics.areEqual((Object)gitRepository, (Object)e.getPresentation().getClientProperty(GitToolbarWidgetActionKt.access$getRepositoryKey$p()))) {
            GitVcsSettings.getInstance(project).setRecentRoot(gitRepository.getRoot().getPath());
        }
        e.getPresentation().putClientProperty(GitToolbarWidgetActionKt.access$getRepositoryKey$p(), (Object)gitRepository);
        GitWidgetState gitWidgetState = state2;
        if (Intrinsics.areEqual((Object)gitWidgetState, (Object)GitWidgetState.OtherVcs.INSTANCE)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (Intrinsics.areEqual((Object)gitWidgetState, (Object)GitWidgetState.NoVcs.INSTANCE)) {
            String placeholder = Companion.getPlaceholder(project);
            Presentation $this$update_u24lambda_u241 = e.getPresentation();
            boolean bl = false;
            $this$update_u24lambda_u241.setEnabledAndVisible(true);
            String string = placeholder;
            if (string == null) {
                string = GitBundle.message("git.toolbar.widget.no.repo", new Object[0]);
            }
            $this$update_u24lambda_u241.setText(string);
            $this$update_u24lambda_u241.setIcon(placeholder != null ? this.widgetIcon : null);
            $this$update_u24lambda_u241.setDescription(GitBundle.message("git.toolbar.widget.no.repo.tooltip", new Object[0]));
        } else if (gitWidgetState instanceof GitWidgetState.Repo) {
            GitRepository repo = ((GitWidgetState.Repo)state2).getRepository();
            Presentation $this$update_u24lambda_u242 = e.getPresentation();
            boolean bl = false;
            $this$update_u24lambda_u242.setEnabledAndVisible(true);
            $this$update_u24lambda_u242.setText(this.calcText(project, repo));
            $this$update_u24lambda_u242.setIcon(this.calcIcon(repo));
            $this$update_u24lambda_u242.setDescription(this.calcTooltip(repo));
        }
        if ((object = gitRepository) != null && (object = object.getCurrentBranchName()) != null) {
            Object branch = object;
            boolean bl = false;
            GitBranchIncomingOutgoingManager gitBranchIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)gitBranchIncomingOutgoingManager, (String)"getInstance(project)");
            GitBranchIncomingOutgoingManager incomingOutgoingManager = gitBranchIncomingOutgoingManager;
            myRepoChanges = new MyRepoChanges(incomingOutgoingManager.hasIncomingFor(gitRepository, (String)branch), incomingOutgoingManager.hasOutgoingFor(gitRepository, (String)branch));
        } else {
            myRepoChanges = new MyRepoChanges(false, false);
        }
        MyRepoChanges changes = myRepoChanges;
        e.getPresentation().putClientProperty(GitToolbarWidgetActionKt.access$getChangesKey$p(), (Object)changes);
    }

    @NlsSafe
    private final String calcText(Project project, GitRepository repository) {
        String string;
        String string2 = StringUtil.escapeMnemonics((String)GitBranchUtil.getDisplayableBranchText(repository, arg_0 -> GitToolbarWidgetAction.calcText$lambda$4(project, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeMnemonics(GitBranc\u2026NAME_LENGTH_DELTA)\n    })");
        String it = string = string2;
        boolean bl = false;
        Companion.updatePlaceholder(project, it);
        return string;
    }

    private final Icon calcIcon(GitRepository $this$calcIcon) {
        if ($this$calcIcon.getState() != Repository.State.NORMAL) {
            Icon icon = AllIcons.General.Warning;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Warning");
            return icon;
        }
        return this.widgetIcon;
    }

    @NlsContexts.Tooltip
    private final String calcTooltip(GitRepository $this$calcTooltip) {
        if ($this$calcTooltip.getState() == Repository.State.DETACHED) {
            String string = GitBundle.message("git.status.bar.widget.tooltip.detached", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"git.status.bar.widget.tooltip.detached\")");
            return string;
        }
        Object[] objectArray = new Object[]{GitVcs.DISPLAY_NAME.get(), GitBranchUtil.getBranchNameOrRev($this$calcTooltip)};
        String string = DvcsBundle.message((String)"tooltip.branch.widget.vcs.branch.name.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"tooltip.branch.\u2026getBranchNameOrRev(this))");
        Object message = string;
        if (!GitUtil.justOneGitRepository($this$calcTooltip.getProject())) {
            message = (String)message + "\n";
            Object[] objectArray2 = new Object[]{$this$calcTooltip.getRoot().getName()};
            message = (String)message + DvcsBundle.message((String)"tooltip.branch.widget.root.name.text", (Object[])objectArray2);
        }
        return message;
    }

    private static final String calcText$lambda$4(Project $project, String branchName) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        return GitBranchPopupActions.truncateBranchName($project, branchName, 80, 5, 4);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\r\u0010\u000f\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/ui/toolbar/GitToolbarWidgetAction$Companion;", "", "()V", "GIT_WIDGET_PLACEHOLDER_KEY", "", "getPlaceholder", "Lcom/intellij/openapi/util/NlsSafe;", "project", "Lcom/intellij/openapi/project/Project;", "getWidgetState", "Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState;", "gitRepository", "Lgit4idea/repo/GitRepository;", "updatePlaceholder", "", "newPlaceholder", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitToolbarWidgetAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitToolbarWidgetAction.kt\ngit4idea/ui/toolbar/GitToolbarWidgetAction$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,212:1\n12744#2,2:213\n*S KotlinDebug\n*F\n+ 1 GitToolbarWidgetAction.kt\ngit4idea/ui/toolbar/GitToolbarWidgetAction$Companion\n*L\n196#1:213,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void updatePlaceholder(@NotNull Project project, @Nullable String newPlaceholder) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PropertiesComponent.getInstance((Project)project).setValue(GitToolbarWidgetAction.GIT_WIDGET_PLACEHOLDER_KEY, newPlaceholder);
        }

        @Nullable
        public final String getPlaceholder(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return PropertiesComponent.getInstance((Project)project).getValue(GitToolbarWidgetAction.GIT_WIDGET_PLACEHOLDER_KEY);
        }

        @NotNull
        public final GitWidgetState getWidgetState(@NotNull Project project, @Nullable GitRepository gitRepository) {
            GitWidgetState gitWidgetState;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (gitRepository != null) {
                return new GitWidgetState.Repo(gitRepository);
            }
            AbstractVcs[] abstractVcsArray = ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss();
            Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getInstance(project).allActiveVcss");
            AbstractVcs[] allVcss = abstractVcsArray;
            if (allVcss.length == 0) {
                gitWidgetState = GitWidgetState.NoVcs.INSTANCE;
            } else {
                boolean bl;
                block4: {
                    AbstractVcs[] $this$any$iv = allVcss;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        AbstractVcs element$iv;
                        AbstractVcs it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual((Object)it.getKeyInstanceMethod(), (Object)GitVcs.getKey()))) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
                gitWidgetState = bl ? (GitWidgetState)GitWidgetState.OtherVcs.INSTANCE : (GitWidgetState)GitWidgetState.NoVcs.INSTANCE;
            }
            return gitWidgetState;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState;", "", "()V", "NoVcs", "OtherVcs", "Repo", "Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState$NoVcs;", "Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState$OtherVcs;", "Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState$Repo;", "intellij.vcs.git"})
    public static abstract class GitWidgetState {
        private GitWidgetState() {
        }

        public /* synthetic */ GitWidgetState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState$NoVcs;", "Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState;", "()V", "intellij.vcs.git"})
        public static final class NoVcs
        extends GitWidgetState {
            @NotNull
            public static final NoVcs INSTANCE = new NoVcs();

            private NoVcs() {
                super(null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState$OtherVcs;", "Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState;", "()V", "intellij.vcs.git"})
        public static final class OtherVcs
        extends GitWidgetState {
            @NotNull
            public static final OtherVcs INSTANCE = new OtherVcs();

            private OtherVcs() {
                super(null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState$Repo;", "Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState;", "repository", "Lgit4idea/repo/GitRepository;", "(Lgit4idea/repo/GitRepository;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
        public static final class Repo
        extends GitWidgetState {
            @NotNull
            private final GitRepository repository;

            public Repo(@NotNull GitRepository repository) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                super(null);
                this.repository = repository;
            }

            @NotNull
            public final GitRepository getRepository() {
                return this.repository;
            }
        }
    }
}

