/*
 * Decompiled with CFR 0.152.
 */
package git4idea.validators;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.GitBranch;
import git4idea.branch.GitBranchesCollection;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u001e\u0010\t\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\n\u001a\u0004\u0018\u00010\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0005\u001a\u00020\u0006\u001a2\u0010\r\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0016\u0010\u0015\u001a\u00020\u00062\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0003\u001a,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0019"}, d2={"checkBranchConflict", "Lcom/intellij/openapi/ui/ValidationInfo;", "repositories", "", "Lgit4idea/repo/GitRepository;", "inputString", "", "checkRefName", "checkRefNameEmptyOrHead", "conflictsWithLocalBranch", "conflictsWithLocalBranchDirectory", "directories", "", "conflictsWithLocalOrRemote", "local", "", "message", "conflictsWithRemoteBranch", "findConflictingBranch", "Lgit4idea/GitBranch;", "repository", "getAdditionalDescription", "", "getReposWithConflictingBranch", "validateName", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitBranchValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchValidator.kt\ngit4idea/validators/GitBranchValidatorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n766#2:75\n857#2,2:76\n1#3:78\n*S KotlinDebug\n*F\n+ 1 GitBranchValidator.kt\ngit4idea/validators/GitBranchValidatorKt\n*L\n69#1:75\n69#1:76,2\n*E\n"})
public final class GitBranchValidatorKt {
    @Nullable
    public static final ValidationInfo validateName(@NotNull Collection<? extends GitRepository> repositories2, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        ValidationInfo validationInfo = GitBranchValidatorKt.checkRefName(inputString);
        if (validationInfo == null) {
            validationInfo = GitBranchValidatorKt.checkBranchConflict(repositories2, inputString);
        }
        return validationInfo;
    }

    @Nullable
    public static final ValidationInfo checkRefName(@Nullable String inputString) {
        ValidationInfo validationInfo = GitBranchValidatorKt.checkRefNameEmptyOrHead(inputString);
        if (validationInfo == null) {
            if (!GitRefNameValidator.getInstance().checkInput(inputString)) {
                Object[] objectArray = new Object[]{inputString};
                ValidationInfo validationInfo2 = new ValidationInfo(GitBundle.message("new.branch.dialog.error.branch.name.invalid", objectArray));
                validationInfo = validationInfo2;
            } else {
                validationInfo = null;
            }
        }
        return validationInfo;
    }

    @Nullable
    public static final ValidationInfo checkRefNameEmptyOrHead(@Nullable String inputString) {
        return StringUtil.isEmptyOrSpaces((String)inputString) ? new ValidationInfo(GitBundle.message("new.branch.dialog.error.branch.name.empty", new Object[0])) : (StringUtil.equalsIgnoreCase((CharSequence)inputString, (CharSequence)"HEAD") ? new ValidationInfo(GitBundle.message("new.branch.dialog.error.branch.name.head", new Object[0])) : null);
    }

    private static final ValidationInfo checkBranchConflict(Collection<? extends GitRepository> repositories2, String inputString) {
        ValidationInfo validationInfo = GitBranchValidatorKt.conflictsWithLocalBranch(repositories2, inputString);
        if (validationInfo == null) {
            validationInfo = GitBranchValidatorKt.conflictsWithRemoteBranch(repositories2, inputString);
        }
        return validationInfo;
    }

    @Nullable
    public static final ValidationInfo conflictsWithLocalBranch(@NotNull Collection<? extends GitRepository> repositories2, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        return GitBranchValidatorKt.conflictsWithLocalOrRemote(repositories2, inputString, true, "new.branch.dialog.error.branch.already.exists");
    }

    @Nullable
    public static final ValidationInfo conflictsWithRemoteBranch(@NotNull Collection<? extends GitRepository> repositories2, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        return GitBranchValidatorKt.conflictsWithLocalOrRemote(repositories2, inputString, false, "new.branch.dialog.error.branch.clashes.with.remote");
    }

    @Nullable
    public static final ValidationInfo conflictsWithLocalBranchDirectory(@NotNull Set<String> directories, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter(directories, (String)"directories");
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        if (directories.contains(inputString)) {
            Object[] objectArray = new Object[]{inputString};
            return new ValidationInfo(GitBundle.message("new.branch.dialog.error.branch.clashes.with.directory", objectArray));
        }
        return null;
    }

    private static final ValidationInfo conflictsWithLocalOrRemote(Collection<? extends GitRepository> repositories2, String inputString, boolean local, @PropertyKey(resourceBundle="messages.GitBundle") String message) {
        List<GitRepository> reposWithConflictingBranch = GitBranchValidatorKt.getReposWithConflictingBranch(repositories2, inputString, local);
        if (reposWithConflictingBranch.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Object[]{inputString};
        String string = GitBundle.message(message, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(message, inputString)");
        Object errorText = string;
        if (repositories2.size() > reposWithConflictingBranch.size()) {
            errorText = (String)errorText + GitBranchValidatorKt.getAdditionalDescription(reposWithConflictingBranch);
            if (local) {
                return new ValidationInfo((String)errorText).asWarning().withOKEnabled();
            }
        }
        return new ValidationInfo((String)errorText);
    }

    @Nls
    private static final String getAdditionalDescription(List<? extends GitRepository> repositories2) {
        String string;
        if (repositories2.size() > 1) {
            Object[] objectArray = new Object[]{repositories2.size()};
            string = GitBundle.message("common.suffix.in.several.repositories", objectArray);
        } else {
            Object[] objectArray = new Object[]{DvcsUtil.getShortRepositoryName((Repository)((Repository)CollectionsKt.first(repositories2)))};
            string = GitBundle.message("common.suffix.in.one.repository", objectArray);
        }
        return " " + string;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<GitRepository> getReposWithConflictingBranch(Collection<? extends GitRepository> repositories2, String inputString, boolean local) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = repositories2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GitRepository repository = (GitRepository)element$iv$iv;
            boolean bl = false;
            if (!(GitBranchValidatorKt.findConflictingBranch(inputString, repository, local) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final GitBranch findConflictingBranch(String inputString, GitRepository repository, boolean local) {
        GitBranchesCollection $this$findConflictingBranch_u24lambda_u241 = repository.getBranches();
        boolean bl = false;
        return local ? (GitBranch)$this$findConflictingBranch_u24lambda_u241.findLocalBranch(inputString) : (GitBranch)$this$findConflictingBranch_u24lambda_u241.findRemoteBranch(inputString);
    }
}

