/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ngram.slp.modeling.ngram;

import com.intellij.completion.ngram.slp.counting.Counter;
import com.intellij.completion.ngram.slp.counting.trie.MapTrieCounter;
import com.intellij.completion.ngram.slp.modeling.ngram.NGramModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0016\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/intellij/completion/ngram/slp/modeling/ngram/ADMModel;", "Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel;", "order", "", "counter", "Lcom/intellij/completion/ngram/slp/counting/Counter;", "(ILcom/intellij/completion/ngram/slp/counting/Counter;)V", "config", "Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel$Config;", "getConfig", "()Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel$Config;", "modelWithConfidence", "Lkotlin/Pair;", "", "in", "", "counts", "", "bd0177eacd27ae4e"})
public final class ADMModel
extends NGramModel {
    @NotNull
    private final NGramModel.Config config;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Pair<Double, Double> modelWithConfidence(@NotNull List<Integer> in, @NotNull long[] counts) {
        double d;
        Intrinsics.checkParameterIsNotNull(in, (String)"in");
        Intrinsics.checkParameterIsNotNull((Object)counts, (String)"counts");
        long count = counts[0];
        long contextCount = counts[1];
        int n1 = this.getCounter().getCountOfCount(in.size(), 1);
        int n2 = this.getCounter().getCountOfCount(in.size(), 2);
        int n3 = this.getCounter().getCountOfCount(in.size(), 3);
        int n4 = this.getCounter().getCountOfCount(in.size(), 4);
        double Y = (double)n1 / ((double)n1 + (double)(2 * n2));
        double[] Ds = new double[]{Y, (double)2 - 3.0 * Y * (double)n3 / (double)n2, (double)3 - 4.0 * Y * (double)n4 / (double)n3};
        int n = 0;
        int n5 = Ds.length;
        while (n < n5) {
            void i;
            if (Double.isNaN(Ds[i]) || Ds[i] < 0.25 * (double)(i + true) || Ds[i] > (double)(i + true)) {
                Ds[i] = 0.6 * (double)(i + true);
            }
            ++i;
        }
        int[] Ns = this.getCounter().getDistinctCounts(3, in.subList(0, in.size() - 1));
        if (count > 0L) {
            long l = Ds.length;
            double[] dArray = Ds;
            boolean bl = false;
            long l2 = Math.min(count, l);
            d = dArray[(int)(l2 - 1L)];
        } else {
            d = 0.0;
        }
        double discount = d;
        double d2 = 0.0;
        double d3 = (double)count - discount;
        boolean bl = false;
        double MLEDisc = Math.max(d2, d3) / (double)contextCount;
        double lambda = 1.0 - (Ds[0] * (double)Ns[0] + Ds[1] * (double)Ns[1] + Ds[2] * (double)Ns[2]) / (double)contextCount;
        return new Pair((Object)(MLEDisc / lambda), (Object)lambda);
    }

    @Override
    @NotNull
    protected NGramModel.Config getConfig() {
        return this.config;
    }

    public ADMModel(int order, @NotNull Counter counter) {
        Intrinsics.checkParameterIsNotNull((Object)counter, (String)"counter");
        super(order, counter);
        this.config = new NGramModel.Config(order, String.valueOf(this.getClass()));
    }

    public /* synthetic */ ADMModel(int n, Counter counter, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 6;
        }
        if ((n2 & 2) != 0) {
            counter = new MapTrieCounter();
        }
        this(n, counter);
    }

    public ADMModel() {
        this(0, null, 3, null);
    }
}

