/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import com.vladsch.flexmark.util.collection.CollectionHost;
import com.vladsch.flexmark.util.collection.iteration.BitSetIterable;
import com.vladsch.flexmark.util.collection.iteration.BitSetIterator;
import com.vladsch.flexmark.util.collection.iteration.Indexed;
import com.vladsch.flexmark.util.collection.iteration.IndexedIterable;
import com.vladsch.flexmark.util.collection.iteration.IndexedIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIndexedIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrderedSet<E>
implements Set<E>,
Iterable<E> {
    @NotNull
    private final HashMap<E, Integer> keyMap;
    @NotNull
    final ArrayList<E> valueList;
    @Nullable
    private final CollectionHost<E> host;
    @Nullable
    private Indexed<E> indexedProxy;
    @Nullable
    private Indexed<E> allowConcurrentModsIndexedProxy;
    @NotNull
    private final BitSet validIndices;
    private int modificationCount;

    public OrderedSet() {
        this(0);
    }

    public OrderedSet(int capacity) {
        this(capacity, null);
    }

    public OrderedSet(@NotNull CollectionHost<E> host) {
        this(0, host);
    }

    public OrderedSet(int capacity, @Nullable CollectionHost<E> host) {
        this.keyMap = new HashMap(capacity);
        this.valueList = new ArrayList(capacity);
        this.validIndices = new BitSet();
        this.host = host;
        this.modificationCount = Integer.MIN_VALUE;
        this.indexedProxy = null;
        this.allowConcurrentModsIndexedProxy = null;
    }

    @NotNull
    public BitSet indexBitSet(@NotNull Iterable<? extends E> items) {
        BitSet bitSet = new BitSet();
        for (E element : items) {
            int i = this.indexOf(element);
            if (i == -1) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    @NotNull
    public BitSet differenceBitSet(@NotNull Iterable<? extends E> items) {
        return this.differenceBitSet(items.iterator());
    }

    @NotNull
    public BitSet differenceBitSet(@NotNull Iterator<? extends E> items) {
        BitSet bitSet = new BitSet();
        int j = 0;
        while (items.hasNext()) {
            E element = items.next();
            int i = this.indexOf(element);
            if (i != j) {
                bitSet.set(i);
            }
            ++j;
        }
        return bitSet;
    }

    @NotNull
    public BitSet keyDifferenceBitSet(@NotNull Iterable<? extends Map.Entry<? extends E, ?>> items) {
        return this.keyDifferenceBitSet(items.iterator());
    }

    @NotNull
    public BitSet keyDifferenceBitSet(@NotNull Iterator<? extends Map.Entry<? extends E, ?>> items) {
        BitSet bitSet = new BitSet();
        int j = 0;
        while (items.hasNext()) {
            Map.Entry<E, ?> entry = items.next();
            int i = this.indexOf(entry.getKey());
            if (i != j) {
                bitSet.set(i);
            }
            ++j;
        }
        return bitSet;
    }

    @NotNull
    public BitSet valueDifferenceBitSet(@NotNull Iterable<? extends Map.Entry<?, ? extends E>> items) {
        return this.valueDifferenceBitSet(items.iterator());
    }

    @NotNull
    public BitSet valueDifferenceBitSet(@NotNull Iterator<? extends Map.Entry<?, ? extends E>> items) {
        BitSet bitSet = new BitSet();
        int j = 0;
        while (items.hasNext()) {
            Map.Entry<?, E> entry = items.next();
            int i = this.indexOf(entry.getValue());
            if (i != j) {
                bitSet.set(i);
            }
            ++j;
        }
        return bitSet;
    }

    @NotNull
    public Indexed<E> getIndexedProxy() {
        if (this.indexedProxy != null) {
            return this.indexedProxy;
        }
        this.indexedProxy = new IndexedProxy(false);
        return this.indexedProxy;
    }

    @NotNull
    public Indexed<E> getConcurrentModsIndexedProxy() {
        if (this.allowConcurrentModsIndexedProxy != null) {
            return this.allowConcurrentModsIndexedProxy;
        }
        this.allowConcurrentModsIndexedProxy = new IndexedProxy(true);
        return this.allowConcurrentModsIndexedProxy;
    }

    public int getModificationCount() {
        return this.modificationCount;
    }

    int getIteratorModificationCount() {
        return this.host != null ? this.host.getIteratorModificationCount() : this.modificationCount;
    }

    public static <T1> T1 ifNull(T1 o, T1 nullValue) {
        return o == null ? nullValue : o;
    }

    public boolean inHostUpdate() {
        return this.host != null && this.host.skipHostUpdate();
    }

    public int indexOf(@Nullable Object element) {
        return OrderedSet.ifNull(this.keyMap.get(element), -1);
    }

    public boolean isValidIndex(int index) {
        return index >= 0 && index < this.valueList.size() && this.validIndices.get(index);
    }

    public void validateIndex(int index) {
        if (!this.isValidIndex(index)) {
            throw new IndexOutOfBoundsException("Index " + index + " is not valid, size=" + this.valueList.size() + " validIndices[" + index + "]=" + this.validIndices.get(index));
        }
    }

    @Nullable
    public E getValue(int index) {
        this.validateIndex(index);
        return this.valueList.get(index);
    }

    @Nullable
    public E getValueOrNull(int index) {
        return this.isValidIndex(index) ? (E)this.valueList.get(index) : null;
    }

    @Override
    public int size() {
        return this.keyMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keyMap.isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.keyMap.containsKey(o);
    }

    @NotNull
    public List<E> getValueList() {
        return this.valueList;
    }

    @NotNull
    public List<E> values() {
        if (!this.isSparse()) {
            return this.valueList;
        }
        ArrayList list = new ArrayList();
        for (Object item : this.iterable()) {
            list.add(item);
        }
        return list;
    }

    public boolean setValueAt(int index, @Nullable E value, @Nullable Object o) {
        int indexOf = this.indexOf(value);
        if (indexOf != -1) {
            if (index != indexOf) {
                throw new IllegalStateException("Trying to add existing element " + value + "[" + indexOf + "] at index " + index);
            }
            return false;
        }
        if (index < this.valueList.size()) {
            if (this.validIndices.get(index)) {
                throw new IllegalStateException("Trying to add new element " + value + " at index " + index + ", already occupied by " + this.valueList.get(index));
            }
        } else if (index > this.valueList.size()) {
            this.addNulls(index - 1);
        }
        if (this.host != null && !this.host.skipHostUpdate()) {
            this.host.adding(index, value, o);
        }
        this.keyMap.put(value, index);
        this.valueList.set(index, value);
        this.validIndices.set(index);
        return true;
    }

    public boolean isSparse() {
        return this.validIndices.nextClearBit(0) < this.valueList.size();
    }

    public void addNull() {
        this.addNulls(this.valueList.size());
    }

    public void addNulls(int index) {
        assert (index >= this.valueList.size());
        if (this.host != null && !this.host.skipHostUpdate()) {
            this.host.addingNulls(index);
        }
        ++this.modificationCount;
        while (this.valueList.size() <= index) {
            this.valueList.add(null);
        }
    }

    @NotNull
    public ReversibleIterator<Integer> indexIterator() {
        return new BitSetIterator(this.validIndices);
    }

    @NotNull
    public ReversibleIterator<Integer> reversedIndexIterator() {
        return new BitSetIterator(this.validIndices, true);
    }

    @NotNull
    public ReversibleIterable<Integer> indexIterable() {
        return new BitSetIterable(this.validIndices);
    }

    @NotNull
    public ReversibleIterable<Integer> reversedIndexIterable() {
        return new BitSetIterable(this.validIndices, true);
    }

    @Override
    @NotNull
    public ReversibleIndexedIterator<E> iterator() {
        return new IndexedIterator(this.getIndexedProxy(), this.indexIterator());
    }

    @NotNull
    public ReversibleIndexedIterator<E> reversedIterator() {
        return new IndexedIterator(this.getIndexedProxy(), this.reversedIndexIterator());
    }

    @NotNull
    public ReversibleIterable<E> iterable() {
        return new IndexedIterable(this.getIndexedProxy(), this.indexIterable());
    }

    @NotNull
    public ReversibleIterable<E> reversedIterable() {
        return new IndexedIterable(this.getIndexedProxy(), this.reversedIndexIterable());
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] objects = new Object[this.keyMap.size()];
        int index = -1;
        int i = -1;
        while (index + 1 < this.valueList.size()) {
            if (!this.validIndices.get(++index)) continue;
            objects[++i] = this.valueList.get(index);
        }
        return objects;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] array) {
        Object[] objects = array;
        if (array.length < this.keyMap.size()) {
            objects = array.getClass() == Object[].class ? new Object[this.keyMap.size()] : (Object[])Array.newInstance(array.getClass().getComponentType(), this.keyMap.size());
        }
        int index = -1;
        int i = -1;
        while (index + 1 < this.valueList.size()) {
            if (!this.validIndices.get(++index)) continue;
            objects[++i] = this.valueList.get(index);
        }
        if (objects.length > ++i) {
            objects[i] = null;
        }
        return objects;
    }

    @Override
    public boolean add(@Nullable E e) {
        return this.add(e, null);
    }

    public boolean add(@Nullable E e, @Nullable Object o) {
        if (this.keyMap.containsKey(e)) {
            return false;
        }
        int i = this.valueList.size();
        if (this.host != null && !this.host.skipHostUpdate()) {
            this.host.adding(i, e, o);
        }
        ++this.modificationCount;
        this.keyMap.put(e, i);
        this.valueList.add(e);
        this.validIndices.set(i);
        return true;
    }

    public boolean removeIndex(int index) {
        return this.removeIndexHosted(index) != null;
    }

    public Object removeIndexHosted(int index) {
        this.validateIndex(index);
        E o = this.valueList.get(index);
        Object r = null;
        r = this.host != null && !this.host.skipHostUpdate() ? this.host.removing(index, o) : (Object)o;
        ++this.modificationCount;
        this.keyMap.remove(o);
        if (this.keyMap.size() == 0) {
            if (this.host != null && !this.host.skipHostUpdate()) {
                this.host.clearing();
            }
            this.valueList.clear();
            this.validIndices.clear();
        } else {
            if (this.host == null && index == this.valueList.size() - 1) {
                this.valueList.remove(index);
            }
            this.validIndices.clear(index);
        }
        return r;
    }

    @Override
    public boolean remove(@Nullable Object o) {
        return this.removeHosted(o) != null;
    }

    @Nullable
    public Object removeHosted(@Nullable Object o) {
        Integer index = this.keyMap.get(o);
        if (index == null) {
            return null;
        }
        return this.removeIndexHosted(index);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        for (Object o : collection) {
            if (this.keyMap.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> collection) {
        boolean[] changed = new boolean[]{false};
        for (E e : collection) {
            if (!this.add(e)) continue;
            changed[0] = true;
        }
        return changed[0];
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        BitSet removeSet = new BitSet(this.valueList.size());
        removeSet.set(0, this.valueList.size());
        removeSet.and(this.validIndices);
        for (Object o : collection) {
            int index = this.indexOf(o);
            if (index == -1) continue;
            removeSet.clear(index);
        }
        int index = this.valueList.size();
        if (index == 0) {
            return false;
        }
        boolean changed = false;
        while (index-- > 0 && (index = removeSet.previousSetBit(index)) != -1) {
            this.remove(this.valueList.get(index));
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        boolean changed = false;
        for (Object o : collection) {
            if (!this.keyMap.containsKey(o) || !this.remove(o)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        if (this.host != null && !this.host.skipHostUpdate()) {
            this.host.clearing();
        }
        ++this.modificationCount;
        this.keyMap.clear();
        this.valueList.clear();
        this.validIndices.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderedSet set = (OrderedSet)o;
        if (this.size() != set.size()) {
            return false;
        }
        Iterator setIterator = set.iterator();
        for (Object e : this) {
            Object eSet;
            if (e.equals(eSet = setIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result2 = this.keyMap.hashCode();
        result2 = 31 * result2 + this.valueList.hashCode();
        result2 = 31 * result2 + this.validIndices.hashCode();
        return result2;
    }

    @NotNull
    public BitSet getValidIndices() {
        return this.validIndices;
    }

    private class IndexedProxy
    implements Indexed<E> {
        private final boolean allowConcurrentMods;

        public IndexedProxy(boolean allowConcurrentMods) {
            this.allowConcurrentMods = allowConcurrentMods;
        }

        @Override
        public E get(int index) {
            return OrderedSet.this.getValue(index);
        }

        @Override
        public void set(int index, E item) {
            OrderedSet.this.setValueAt(index, item, null);
        }

        @Override
        public void removeAt(int index) {
            OrderedSet.this.removeIndexHosted(index);
        }

        @Override
        public int size() {
            return OrderedSet.this.valueList.size();
        }

        @Override
        public int modificationCount() {
            return this.allowConcurrentMods ? 0 : OrderedSet.this.getIteratorModificationCount();
        }
    }
}

