/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PackedLongValues;

public class OrdinalMap
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(OrdinalMap.class);
    public final IndexReader.CacheKey owner;
    final long valueCount;
    final LongValues globalOrdDeltas;
    final LongValues firstSegments;
    final LongValues[] segmentToGlobalOrds;
    final SegmentMap segmentMap;
    final long ramBytesUsed;

    public static OrdinalMap build(IndexReader.CacheKey owner, SortedDocValues[] values, float acceptableOverheadRatio) throws IOException {
        TermsEnum[] subs = new TermsEnum[values.length];
        long[] weights = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            subs[i] = values[i].termsEnum();
            weights[i] = values[i].getValueCount();
        }
        return OrdinalMap.build(owner, subs, weights, acceptableOverheadRatio);
    }

    public static OrdinalMap build(IndexReader.CacheKey owner, SortedSetDocValues[] values, float acceptableOverheadRatio) throws IOException {
        TermsEnum[] subs = new TermsEnum[values.length];
        long[] weights = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            subs[i] = values[i].termsEnum();
            weights[i] = values[i].getValueCount();
        }
        return OrdinalMap.build(owner, subs, weights, acceptableOverheadRatio);
    }

    public static OrdinalMap build(IndexReader.CacheKey owner, TermsEnum[] subs, long[] weights, float acceptableOverheadRatio) throws IOException {
        if (subs.length != weights.length) {
            throw new IllegalArgumentException("subs and weights must have the same length");
        }
        SegmentMap segmentMap = new SegmentMap(weights);
        return new OrdinalMap(owner, subs, segmentMap, acceptableOverheadRatio);
    }

    OrdinalMap(IndexReader.CacheKey owner, TermsEnum[] subs, SegmentMap segmentMap, float acceptableOverheadRatio) throws IOException {
        this.owner = owner;
        this.segmentMap = segmentMap;
        PackedLongValues.Builder globalOrdDeltas = PackedLongValues.monotonicBuilder(0.0f);
        PackedLongValues.Builder firstSegments = PackedLongValues.packedBuilder(0.0f);
        long firstSegmentBits = 0L;
        PackedLongValues.Builder[] ordDeltas = new PackedLongValues.Builder[subs.length];
        for (int i = 0; i < ordDeltas.length; ++i) {
            ordDeltas[i] = PackedLongValues.monotonicBuilder(acceptableOverheadRatio);
        }
        long[] ordDeltaBits = new long[subs.length];
        long[] segmentOrds = new long[subs.length];
        PriorityQueue<TermsEnumIndex> queue = new PriorityQueue<TermsEnumIndex>(subs.length){

            @Override
            protected boolean lessThan(TermsEnumIndex a, TermsEnumIndex b) {
                return a.currentTerm.compareTo(b.currentTerm) < 0;
            }
        };
        for (int i = 0; i < subs.length; ++i) {
            TermsEnumIndex sub = new TermsEnumIndex(subs[segmentMap.newToOld(i)], i);
            if (sub.next() == null) continue;
            queue.add(sub);
        }
        BytesRefBuilder scratch = new BytesRefBuilder();
        long globalOrd = 0L;
        while (queue.size() != 0) {
            TermsEnumIndex top = (TermsEnumIndex)queue.top();
            scratch.copyBytes(top.currentTerm);
            int firstSegmentIndex = Integer.MAX_VALUE;
            long globalOrdDelta = Long.MAX_VALUE;
            do {
                top = (TermsEnumIndex)queue.top();
                long segmentOrd = top.termsEnum.ord();
                long delta = globalOrd - segmentOrd;
                int segmentIndex = top.subIndex;
                if (segmentIndex < firstSegmentIndex) {
                    firstSegmentIndex = segmentIndex;
                    globalOrdDelta = delta;
                }
                int n = segmentIndex;
                ordDeltaBits[n] = ordDeltaBits[n] | delta;
                assert (segmentOrds[segmentIndex] <= segmentOrd);
                do {
                    ordDeltas[segmentIndex].add(delta);
                    int n2 = segmentIndex;
                    segmentOrds[n2] = segmentOrds[n2] + 1L;
                } while (segmentOrds[segmentIndex] <= segmentOrd);
                if (top.next() == null) {
                    queue.pop();
                    if (queue.size() != 0) continue;
                    break;
                }
                queue.updateTop();
            } while (((TermsEnumIndex)queue.top()).currentTerm.equals(scratch.get()));
            firstSegments.add(firstSegmentIndex);
            firstSegmentBits |= (long)firstSegmentIndex;
            globalOrdDeltas.add(globalOrdDelta);
            ++globalOrd;
        }
        long ramBytesUsed = BASE_RAM_BYTES_USED + segmentMap.ramBytesUsed();
        this.valueCount = globalOrd;
        if (ordDeltaBits.length > 0 && ordDeltaBits[0] == 0L && firstSegmentBits == 0L) {
            this.firstSegments = LongValues.ZEROES;
            this.globalOrdDeltas = LongValues.ZEROES;
        } else {
            PackedLongValues packedFirstSegments = firstSegments.build();
            PackedLongValues packedGlobalOrdDeltas = globalOrdDeltas.build();
            this.firstSegments = packedFirstSegments;
            this.globalOrdDeltas = packedGlobalOrdDeltas;
            ramBytesUsed += packedFirstSegments.ramBytesUsed() + packedGlobalOrdDeltas.ramBytesUsed();
        }
        this.segmentToGlobalOrds = new LongValues[subs.length];
        ramBytesUsed += RamUsageEstimator.shallowSizeOf(this.segmentToGlobalOrds);
        for (int i = 0; i < ordDeltas.length; ++i) {
            final PackedLongValues deltas = ordDeltas[i].build();
            if (ordDeltaBits[i] == 0L) {
                this.segmentToGlobalOrds[i] = LongValues.IDENTITY;
                continue;
            }
            int bitsRequired = ordDeltaBits[i] < 0L ? 64 : PackedInts.bitsRequired(ordDeltaBits[i]);
            long monotonicBits = deltas.ramBytesUsed() * 8L;
            long packedBits = (long)bitsRequired * deltas.size();
            if (deltas.size() <= Integer.MAX_VALUE && (float)packedBits <= (float)monotonicBits * (1.0f + acceptableOverheadRatio)) {
                int size = (int)deltas.size();
                final PackedInts.Mutable newDeltas = PackedInts.getMutable(size, bitsRequired, acceptableOverheadRatio);
                PackedLongValues.Iterator it = deltas.iterator();
                for (int ord = 0; ord < size; ++ord) {
                    newDeltas.set(ord, it.next());
                }
                assert (!it.hasNext());
                this.segmentToGlobalOrds[i] = new LongValues(){

                    @Override
                    public long get(long ord) {
                        return ord + newDeltas.get((int)ord);
                    }
                };
                ramBytesUsed += newDeltas.ramBytesUsed();
            } else {
                this.segmentToGlobalOrds[i] = new LongValues(){

                    @Override
                    public long get(long ord) {
                        return ord + deltas.get(ord);
                    }
                };
                ramBytesUsed += deltas.ramBytesUsed();
            }
            ramBytesUsed += RamUsageEstimator.shallowSizeOf(this.segmentToGlobalOrds[i]);
        }
        this.ramBytesUsed = ramBytesUsed;
    }

    public LongValues getGlobalOrds(int segmentIndex) {
        return this.segmentToGlobalOrds[this.segmentMap.oldToNew(segmentIndex)];
    }

    public long getFirstSegmentOrd(long globalOrd) {
        return globalOrd - this.globalOrdDeltas.get(globalOrd);
    }

    public int getFirstSegmentNumber(long globalOrd) {
        return this.segmentMap.newToOld((int)this.firstSegments.get(globalOrd));
    }

    public long getValueCount() {
        return this.valueCount;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        resources.add(Accountables.namedAccountable("segment map", this.segmentMap));
        return resources;
    }

    private static class SegmentMap
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SegmentMap.class);
        private final int[] newToOld;
        private final int[] oldToNew;

        private static int[] map(final long[] weights) {
            final int[] newToOld = new int[weights.length];
            for (int i = 0; i < weights.length; ++i) {
                newToOld[i] = i;
            }
            new InPlaceMergeSorter(){

                @Override
                protected void swap(int i, int j) {
                    int tmp = newToOld[i];
                    newToOld[i] = newToOld[j];
                    newToOld[j] = tmp;
                }

                @Override
                protected int compare(int i, int j) {
                    return Long.compare(weights[newToOld[j]], weights[newToOld[i]]);
                }
            }.sort(0, weights.length);
            return newToOld;
        }

        private static int[] inverse(int[] map2) {
            int[] inverse = new int[map2.length];
            for (int i = 0; i < map2.length; ++i) {
                inverse[map2[i]] = i;
            }
            return inverse;
        }

        SegmentMap(long[] weights) {
            this.newToOld = SegmentMap.map(weights);
            this.oldToNew = SegmentMap.inverse(this.newToOld);
            assert (Arrays.equals(this.newToOld, SegmentMap.inverse(this.oldToNew)));
        }

        int newToOld(int segment) {
            return this.newToOld[segment];
        }

        int oldToNew(int segment) {
            return this.oldToNew[segment];
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.newToOld) + RamUsageEstimator.sizeOf(this.oldToNew);
        }
    }

    private static class TermsEnumIndex {
        final int subIndex;
        final TermsEnum termsEnum;
        BytesRef currentTerm;

        public TermsEnumIndex(TermsEnum termsEnum, int subIndex) {
            this.termsEnum = termsEnum;
            this.subIndex = subIndex;
        }

        public BytesRef next() throws IOException {
            this.currentTerm = this.termsEnum.next();
            return this.currentTerm;
        }
    }
}

