/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html.entities;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.html.entities.Entities;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/intellij/markdown/html/entities/EntityConverter;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "REGEX_ESCAPES", "escapeAllowedString", "", "replacements", "", "", "replaceEntities", "text", "", "processEntities", "", "processEscapes", "markdown"})
public final class EntityConverter {
    @NotNull
    public static final EntityConverter INSTANCE = new EntityConverter();
    @NotNull
    private static final String escapeAllowedString = "!\"#\\$%&'\\(\\)\\*\\+,\\-.\\/:;<=>\\?@\\[\\\\\\]\\^_`{\\|}~";
    @NotNull
    private static final Map<Character, String> replacements;
    @NotNull
    private static final Regex REGEX;
    @NotNull
    private static final Regex REGEX_ESCAPES;

    private EntityConverter() {
    }

    @NotNull
    public final String replaceEntities(@NotNull CharSequence text, boolean processEntities, boolean processEscapes) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return (processEscapes ? REGEX_ESCAPES : REGEX).replace(text, (Function1)new Function1<MatchResult, CharSequence>(processEntities){
            final /* synthetic */ boolean $processEntities;
            {
                this.$processEntities = $processEntities;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult match) {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter((Object)match, (String)"match");
                MatchGroupCollection g = match.getGroups();
                if (g.size() > 5 && g.get(5) != null) {
                    MatchGroup matchGroup = g.get(5);
                    Intrinsics.checkNotNull((Object)matchGroup);
                    char c = matchGroup.getValue().charAt(0);
                    String string = (String)EntityConverter.access$getReplacements$p().get(Character.valueOf(c));
                    charSequence = string == null ? String.valueOf(c) : string;
                } else if (g.get(4) != null) {
                    Map map2 = EntityConverter.access$getReplacements$p();
                    MatchGroup matchGroup = g.get(4);
                    Intrinsics.checkNotNull((Object)matchGroup);
                    String c = (String)map2.get(Character.valueOf(matchGroup.getValue().charAt(0)));
                    charSequence = c == null ? match.getValue() : c;
                } else {
                    Object object;
                    Character c;
                    int n;
                    int n2;
                    String string;
                    Integer n3;
                    if (!this.$processEntities) {
                        n3 = null;
                    } else if (g.get(1) != null) {
                        n3 = Entities.INSTANCE.getMap().get(match.getValue());
                    } else if (g.get(2) != null) {
                        MatchGroup matchGroup = g.get(2);
                        Intrinsics.checkNotNull((Object)matchGroup);
                        string = matchGroup.getValue();
                        n2 = 0;
                        n3 = Integer.parseInt(string);
                    } else if (g.get(3) != null) {
                        MatchGroup matchGroup = g.get(3);
                        Intrinsics.checkNotNull((Object)matchGroup);
                        string = matchGroup.getValue();
                        n2 = 16;
                        n = 0;
                        n3 = Integer.parseInt(string, CharsKt.checkRadix((int)n2));
                    } else {
                        n3 = null;
                    }
                    Integer code = n3;
                    Object object2 = code;
                    Character c2 = c = object2 == null ? null : Character.valueOf((char)((Integer)object2).intValue());
                    if (c != null) {
                        object2 = (String)EntityConverter.access$getReplacements$p().get(c);
                        object = object2 == null ? c.toString() : object2;
                    } else {
                        object2 = match.getValue();
                        n = 1;
                        boolean bl = false;
                        Object object3 = object2;
                        if (object3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string2 = ((String)object3).substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                        object = Intrinsics.stringPlus((String)"&amp;", (Object)string2);
                    }
                    charSequence = (CharSequence)object;
                }
                return charSequence;
            }
        });
    }

    public static final /* synthetic */ Map access$getReplacements$p() {
        return replacements;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('\"'), (Object)"&quot;"), TuplesKt.to((Object)Character.valueOf('&'), (Object)"&amp;"), TuplesKt.to((Object)Character.valueOf('<'), (Object)"&lt;"), TuplesKt.to((Object)Character.valueOf('>'), (Object)"&gt;")};
        replacements = MapsKt.mapOf((Pair[])pairArray);
        REGEX = new Regex("&(?:([a-zA-Z0-9]+)|#([0-9]{1,8})|#[xX]([a-fA-F0-9]{1,8}));|([\"&<>])");
        REGEX_ESCAPES = new Regex(Intrinsics.stringPlus((String)REGEX.getPattern(), (Object)"|\\\\([!\"#\\$%&'\\(\\)\\*\\+,\\-.\\/:;<=>\\?@\\[\\\\\\]\\^_`{\\|}~])"));
    }
}

