/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.util;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\n\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0004B!\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00028\u00012\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/projector/server/core/util/ObjectIdCacher;", "IdType", "", "ObjectType", "", "initialId", "incrementer", "Lkotlin/Function1;", "(Ljava/lang/Number;Lkotlin/jvm/functions/Function1;)V", "idToObject", "", "nextId", "Ljava/lang/Number;", "objectToId", "getIdBy", "obj", "(Ljava/lang/Object;)Ljava/lang/Number;", "getObjectBy", "id", "(Ljava/lang/Number;)Ljava/lang/Object;", "projector-server-core"})
public final class ObjectIdCacher<IdType extends Number, ObjectType> {
    @NotNull
    private final Function1<IdType, IdType> incrementer;
    @NotNull
    private IdType nextId;
    @NotNull
    private final Map<IdType, ObjectType> idToObject;
    @NotNull
    private final Map<ObjectType, IdType> objectToId;

    public ObjectIdCacher(@NotNull IdType initialId, @NotNull Function1<? super IdType, ? extends IdType> incrementer) {
        Intrinsics.checkNotNullParameter(initialId, (String)"initialId");
        Intrinsics.checkNotNullParameter(incrementer, (String)"incrementer");
        this.incrementer = incrementer;
        this.nextId = initialId;
        this.idToObject = new LinkedHashMap();
        this.objectToId = new LinkedHashMap();
    }

    @NotNull
    public final IdType getIdBy(@NotNull ObjectType obj) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        Number id = (Number)this.objectToId.get(obj);
        if (id != null) {
            return (IdType)id;
        }
        IdType newId = this.nextId;
        this.nextId = (Number)this.incrementer.invoke(this.nextId);
        this.idToObject.put(newId, obj);
        this.objectToId.put(obj, newId);
        return newId;
    }

    @NotNull
    public final ObjectType getObjectBy(@NotNull IdType id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        ObjectType ObjectType = this.idToObject.get(id);
        if (ObjectType == null) {
            boolean bl = false;
            String string = "No id " + id + " found. Available ids: " + this.idToObject;
            throw new IllegalArgumentException(string.toString());
        }
        return ObjectType;
    }
}

