/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.highlight;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.DaemonTooltipsUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.navigation.JBProtocolRevisionResolver;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.actions.QodanaRootIgnoreIntention;
import org.jetbrains.qodana.actions.QodanaSuppressableProblemGroup;
import org.jetbrains.qodana.actions.StopShowingReportAction;
import org.jetbrains.qodana.extensions.QodanaHighlightInfoTypeProvider;
import org.jetbrains.qodana.extensions.RepositoryRevisionProvider;
import org.jetbrains.qodana.highlight.HighlightedReportData;
import org.jetbrains.qodana.highlight.HighlightedReportState;
import org.jetbrains.qodana.highlight.HighlightedReportStateKt;
import org.jetbrains.qodana.highlight.ProblemWithRange;
import org.jetbrains.qodana.highlight.QodanaHighlightedReportService;
import org.jetbrains.qodana.highlight.QodanaReportHighlightingPass;
import org.jetbrains.qodana.highlight.QodanaRevisionData;
import org.jetbrains.qodana.highlight.QodanaRevisionDataKt;
import org.jetbrains.qodana.highlight.SarifInspectionDescriptionLinkHandler;
import org.jetbrains.qodana.highlight.SarifProblemPropertiesUpdater;
import org.jetbrains.qodana.problem.SarifProblem;
import org.jetbrains.qodana.problem.SarifProblemKt;
import org.jetbrains.qodana.problem.SarifProblemProperties;
import org.jetbrains.qodana.settings.ConfigExcludeItem;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001+B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J<\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0016\u0010\u0018\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001c\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\"\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J.\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\b\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010'\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010)\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/qodana/highlight/QodanaReportHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "Lcom/intellij/openapi/project/DumbAware;", "myFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "reportService", "Lorg/jetbrains/qodana/highlight/QodanaHighlightedReportService;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/qodana/highlight/QodanaHighlightedReportService;)V", "myHighlightInfos", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "buildHighlightInfo", "problem", "Lorg/jetbrains/qodana/problem/SarifProblem;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "toolId", "", "calculateTextRanges", "", "Lorg/jetbrains/qodana/highlight/ProblemWithRange;", "relevantProblems", "revisionPsiFiles", "", "highlightedReportData", "Lorg/jetbrains/qodana/highlight/HighlightedReportData;", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getPsiFileByRevision", "revisionId", "getPsiFileForLastRevision", "getTextRangesForRevision", "problems", "revisionPsiFile", "isProblemSuppressed", "", "updateProblemsRanges", "problemsWithRanges", "Registrar", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaReportHighlightingPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaReportHighlightingPass.kt\norg/jetbrains/qodana/highlight/QodanaReportHighlightingPass\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,236:1\n1#2:237\n1#2:274\n766#3:238\n857#3,2:239\n766#3:241\n857#3:242\n1747#3,3:243\n858#3:246\n1549#3:247\n1620#3,3:248\n1747#3,3:251\n1603#3,9:264\n1855#3:273\n1856#3:275\n1612#3:276\n1549#3:277\n1620#3,3:278\n1477#3:281\n1502#3,3:282\n1505#3,3:292\n1549#3:301\n1620#3,3:302\n1864#3,3:305\n1726#3,3:308\n42#4,10:254\n361#5,7:285\n76#6:295\n96#6,5:296\n*S KotlinDebug\n*F\n+ 1 QodanaReportHighlightingPass.kt\norg/jetbrains/qodana/highlight/QodanaReportHighlightingPass\n*L\n84#1:274\n56#1:238\n56#1:239,2\n57#1:241\n57#1:242\n58#1:243,3\n57#1:246\n65#1:247\n65#1:248,3\n69#1:251,3\n84#1:264,9\n84#1:273\n84#1:275\n84#1:276\n95#1:277\n95#1:278,3\n122#1:281\n122#1:282,3\n122#1:292,3\n133#1:301\n133#1:302,3\n147#1:305,3\n182#1:308,3\n71#1:254,10\n122#1:285,7\n123#1:295\n123#1:296,5\n*E\n"})
public final class QodanaReportHighlightingPass
extends TextEditorHighlightingPass
implements DumbAware {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final Editor editor;
    @NotNull
    private final QodanaHighlightedReportService reportService;
    @NotNull
    private final List<HighlightInfo> myHighlightInfos;

    public QodanaReportHighlightingPass(@NotNull PsiFile myFile, @NotNull Editor editor, @NotNull QodanaHighlightedReportService reportService) {
        Intrinsics.checkNotNullParameter((Object)myFile, (String)"myFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)reportService, (String)"reportService");
        super(myFile.getProject(), editor.getDocument());
        this.myFile = myFile;
        this.editor = editor;
        this.reportService = reportService;
        this.myHighlightInfos = new ArrayList();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        block23: {
            block25: {
                block24: {
                    Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
                    v0 = this.myFile.getVirtualFile();
                    if (v0 == null) {
                        return;
                    }
                    virtualFile = v0;
                    v1 = this.myProject;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"myProject");
                    v2 /* !! */  = ProjectUtil.guessProjectDir((Project)v1);
                    if (v2 /* !! */  == null) break block24;
                    it /* !! */  = v2 /* !! */ ;
                    $i$a$-let-QodanaReportHighlightingPass$doCollectInformation$projectDir$1 = false;
                    v3 = it /* !! */ .getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it.path");
                    v4 = Paths.get(v3, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"get(path)");
                    v2 /* !! */  = v4;
                    if (v4 != null) break block25;
                }
                return;
            }
            projectDir /* !! */  = v2 /* !! */ ;
            this.myHighlightInfos.clear();
            v5 = HighlightedReportStateKt.getHighlightedReportDataIfSelected((HighlightedReportState)this.reportService.getHighlightedReportState().getValue());
            if (v5 == null) {
                return;
            }
            highlightedReportData = v5;
            v6 = virtualFile.getCanonicalPath();
            if (v6 == null) {
                v6 = virtualFile.getPath();
            }
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"virtualFile.canonicalPath ?: virtualFile.path");
            virtualFilePath = v6;
            v7 = Paths.get(virtualFilePath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"get(path)");
            it /* !! */  = highlightedReportData.getRelevantProblemsByFilePath((Path)projectDir /* !! */ , v7);
            $i$f$filter = false;
            var9_9 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (SarifProblem)element$iv$iv;
                $i$a$-filter-QodanaReportHighlightingPass$doCollectInformation$relevantProblems$1 = false;
                if (!it.getHasRange()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                block22: {
                    problem = (SarifProblem)element$iv$iv;
                    $i$a$-filter-QodanaReportHighlightingPass$doCollectInformation$relevantProblems$2 = false;
                    $this$any$iv = (Iterable)highlightedReportData.getExcludedDataFlow().getValue();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v8 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            data = (ConfigExcludeItem)element$iv;
                            $i$a$-any-QodanaReportHighlightingPass$doCollectInformation$relevantProblems$2$1 = false;
                            if (!data.isRelatedToProblem(problem)) continue;
                            v8 = true;
                            break block22;
                        }
                        v8 = false;
                    }
                }
                v9 = !v8;
                if (!v9) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            relevantProblems = (List)destination$iv$iv;
            if (relevantProblems.isEmpty()) {
                return;
            }
            $this$map$iv = relevantProblems;
            $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            destination$iv$iv = (List<HighlightInfo>)new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (E item$iv$iv : $this$mapTo$iv$iv) {
                $i$a$-filter-QodanaReportHighlightingPass$doCollectInformation$relevantProblems$2 = (SarifProblem)item$iv$iv;
                var28_38 = destination$iv$iv;
                $i$a$-map-QodanaReportHighlightingPass$doCollectInformation$revisionIds$1 = false;
                var28_38.add((HighlightInfo)it.getRevisionId());
            }
            revisionIds = CollectionsKt.toSet((Iterable)destination$iv$iv);
            data = (QodanaRevisionData)this.editor.getDocument().getUserData(QodanaRevisionDataKt.getQODANA_REVISION_DATA());
            if (data == null || !Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)data.getRevisionIdsToPsiFiles().keySet()), (Object)revisionIds)) ** GOTO lbl-1000
            $this$any$iv = CollectionsKt.toSet((Iterable)data.getRevisionIdsToPsiFiles().values());
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v10 = false;
            } else {
                $i$f$mapTo = $this$any$iv.iterator();
                while ($i$f$mapTo.hasNext()) {
                    element$iv = $i$f$mapTo.next();
                    it = (PsiFile)element$iv;
                    $i$a$-any-QodanaReportHighlightingPass$doCollectInformation$dataIsIncorrect$1 = false;
                    v11 = it;
                    v12 = v11 != null ? !v11.isValid() : false;
                    if (!v12) continue;
                    v10 = true;
                    break block23;
                }
                v10 = false;
            }
        }
        if (v10) lbl-1000:
        // 2 sources

        {
            v13 = true;
        } else {
            v13 = dataIsIncorrect = false;
        }
        if (dataIsIncorrect) {
            $i$f$any = new Object[]{this.myFile.getName()};
            v14 = QodanaBundle.message("progress.title.qodana.highlight.calc", $i$f$any);
            Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"message(\"progress.title.\u2026light.calc\", myFile.name)");
            $this$any$iv = v14;
            project$iv = this.myProject;
            cancellable$iv = true;
            $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, revisionIds, this){
                final /* synthetic */ Set $revisionIds$inlined;
                final /* synthetic */ QodanaReportHighlightingPass this$0;
                {
                    this.$revisionIds$inlined = set;
                    this.this$0 = qodanaReportHighlightingPass;
                    super($project, $title, $cancellable);
                }

                /*
                 * WARNING - void declaration
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    Iterable $this$associateWith$iv = this.$revisionIds$inlined;
                    boolean $i$f$associateWith = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                    Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                    boolean $i$f$associateWithTo = false;
                    for (T element$iv$iv : $this$associateWithTo$iv$iv) {
                        void it2;
                        String string = (String)element$iv$iv;
                        T t = element$iv$iv;
                        Map map2 = result$iv;
                        boolean bl2 = false;
                        PsiFile psiFile2 = QodanaReportHighlightingPass.access$getPsiFileByRevision(this.this$0, QodanaReportHighlightingPass.access$getMyFile$p(this.this$0), (String)it2);
                        if (psiFile2 == null) {
                            psiFile2 = QodanaReportHighlightingPass.access$getPsiFileForLastRevision(this.this$0, QodanaReportHighlightingPass.access$getMyFile$p(this.this$0));
                        }
                        PsiFile psiFile3 = psiFile2;
                        map2.put(t, psiFile3);
                    }
                    Map psiFiles = result$iv;
                    QodanaReportHighlightingPass.access$getEditor$p(this.this$0).getDocument().putUserData(QodanaRevisionDataKt.getQODANA_REVISION_DATA(), (Object)new QodanaRevisionData(psiFiles));
                    DaemonCodeAnalyzer.getInstance((Project)QodanaReportHighlightingPass.access$getMyProject$p$s1464811777(this.this$0)).restart(QodanaReportHighlightingPass.access$getMyFile$p(this.this$0));
                }
            });
            return;
        }
        v15 = data;
        Intrinsics.checkNotNull((Object)v15);
        relevantProblemsWithRanges = this.calculateTextRanges(relevantProblems, v15.getRevisionIdsToPsiFiles(), highlightedReportData);
        project$iv = relevantProblemsWithRanges;
        var28_38 = this.myHighlightInfos;
        $i$f$mapNotNull = false;
        $i$f$runBackgroundableTask = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var18_33 = $this$forEach$iv$iv$iv.iterator();
        while (var18_33.hasNext()) {
            element$iv$iv = element$iv$iv$iv = var18_33.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            var22_39 = (ProblemWithRange)element$iv$iv;
            $i$a$-mapNotNull-QodanaReportHighlightingPass$doCollectInformation$2 = false;
            problem = var22_39.component1();
            if (this.buildHighlightInfo(problem, range = var22_39.component2(), highlightedReportData.getInspectionsInfoProvider().getSuppressIdByInspection(problem.getInspectionId())) == null) continue;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        var28_38.addAll((List)destination$iv$iv);
        if (virtualFile.isInLocalFileSystem()) {
            this.updateProblemsRanges(highlightedReportData, relevantProblemsWithRanges);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateProblemsRanges(HighlightedReportData highlightedReportData, List<ProblemWithRange> problemsWithRanges) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = problemsWithRanges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SarifProblemPropertiesUpdater sarifProblemPropertiesUpdater;
            ProblemWithRange problemWithRange = (ProblemWithRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SarifProblem problem = problemWithRange.component1();
            TextRange textRange = problemWithRange.component2();
            if (textRange == null) {
                sarifProblemPropertiesUpdater = new SarifProblemPropertiesUpdater(problem, (Function1<? super SarifProblemProperties, SarifProblemProperties>)((Function1)updateProblemsRanges.propertiesUpdaters.1.1.INSTANCE));
            } else {
                int line = this.getDocument().getLineNumber(textRange.getStartOffset());
                int lineStartOffset = this.getDocument().getLineStartOffset(line);
                int column = textRange.getStartOffset() - lineStartOffset;
                sarifProblemPropertiesUpdater = new SarifProblemPropertiesUpdater(problem, (Function1<? super SarifProblemProperties, SarifProblemProperties>)((Function1)new Function1<SarifProblemProperties, SarifProblemProperties>(line, column){
                    final /* synthetic */ int $line;
                    final /* synthetic */ int $column;
                    {
                        this.$line = $line;
                        this.$column = $column;
                        super(1);
                    }

                    @NotNull
                    public final SarifProblemProperties invoke(@NotNull SarifProblemProperties it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return SarifProblemProperties.copy$default(it, false, false, this.$line, this.$column, 1, null);
                    }
                }));
            }
            collection.add(sarifProblemPropertiesUpdater);
        }
        List propertiesUpdaters2 = (List)destination$iv$iv;
        highlightedReportData.updateProblemsProperties(propertiesUpdaters2);
    }

    private final PsiFile getPsiFileByRevision(PsiFile myFile, String revisionId) {
        PsiFile psiFile2;
        if (revisionId == null) {
            return null;
        }
        String string = myFile.getVirtualFile().getCanonicalPath();
        if (string == null) {
            return null;
        }
        String path = string;
        VirtualFile virtualFile2 = JBProtocolRevisionResolver.processResolvers((Project)this.myProject, (String)path, (String)revisionId);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile revisionFile = virtualFile2;
        PsiFile psiFile3 = psiFile2 = (PsiFile)ActionsKt.runReadAction((Function0)((Function0)new Function0<PsiFile>(this, revisionFile){
            final /* synthetic */ QodanaReportHighlightingPass this$0;
            final /* synthetic */ VirtualFile $revisionFile;
            {
                this.this$0 = $receiver;
                this.$revisionFile = $revisionFile;
                super(0);
            }

            @Nullable
            public final PsiFile invoke() {
                return PsiManager.getInstance((Project)QodanaReportHighlightingPass.access$getMyProject$p$s1464811777(this.this$0)).findFile(this.$revisionFile);
            }
        }));
        return (psiFile3 != null ? !psiFile3.isValid() : false) ? null : psiFile2;
    }

    private final PsiFile getPsiFileForLastRevision(PsiFile myFile) {
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        String currentRevision = RepositoryRevisionProvider.Companion.getRepositoryRevision(project2, myFile.getVirtualFile());
        return this.getPsiFileByRevision(myFile, currentRevision);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProblemWithRange> calculateTextRanges(List<SarifProblem> relevantProblems, Map<String, ? extends PsiFile> revisionPsiFiles, HighlightedReportData highlightedReportData) {
        void $this$flatMapTo$iv$iv;
        Map problemsByRevision;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = relevantProblems;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            SarifProblem it = (SarifProblem)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getRevisionId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$flatMap$iv = problemsByRevision = destination$iv$iv;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            String revisionId = (String)entry.getKey();
            List problems2 = (List)entry.getValue();
            Iterable list$iv$iv = this.getTextRangesForRevision(problems2, revisionPsiFiles.get(revisionId), highlightedReportData);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List ranges2 = (List)destination$iv$iv2;
        return ranges2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProblemWithRange> getTextRangesForRevision(List<SarifProblem> problems2, PsiFile revisionPsiFile, HighlightedReportData highlightedReportData) {
        int n;
        ArrayList<ProblemWithRange> arrayList;
        void $this$mapTo$iv$iv;
        if (problems2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = problems2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        ArrayList<ProblemWithRange> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SarifProblem sarifProblem = (SarifProblem)item$iv$iv;
            arrayList = destination$iv$iv;
            n = 0;
            Document document2 = this.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"document");
            arrayList.add(new ProblemWithRange((SarifProblem)it, it.getTextRangeInDocument(document2)));
        }
        List rangesInCurrentDocument = destination$iv$iv;
        if (revisionPsiFile == null || highlightedReportData.isIdeRun()) {
            return rangesInCurrentDocument;
        }
        Document revisionDocument = revisionPsiFile.getViewProvider().getDocument();
        if (revisionDocument == null) {
            return rangesInCurrentDocument;
        }
        OffsetsInFile offsetsInFile = new OffsetsInFile(revisionPsiFile);
        List keys = new ArrayList();
        Iterable $this$forEachIndexed$iv = problems2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void problem;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SarifProblem sarifProblem = (SarifProblem)item$iv;
            int index = n;
            boolean bl = false;
            OffsetKey start = OffsetKey.create((String)("START" + index));
            OffsetKey end = OffsetKey.create((String)("END" + index));
            keys.add(TuplesKt.to((Object)start, (Object)end));
            TextRange oldTextRange = problem.getTextRangeInDocument(revisionDocument);
            if (oldTextRange == null) continue;
            offsetsInFile.getOffsets().addOffset(start, oldTextRange.getStartOffset());
            offsetsInFile.getOffsets().addOffset(end, oldTextRange.getEndOffset());
        }
        int n2 = revisionPsiFile.getTextRange().getEndOffset();
        String string = this.myFile.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myFile.text");
        OffsetMap newOffsets = offsetsInFile.copyWithReplacement(0, n2, string).getOffsets();
        int n3 = problems2.size();
        ArrayList<ProblemWithRange> arrayList2 = new ArrayList<ProblemWithRange>(n3);
        for (int i = 0; i < n3; ++i) {
            ProblemWithRange problemWithRange;
            boolean rangeCalculatedSuccessfully;
            void index;
            int n4;
            n = n4 = i;
            arrayList = arrayList2;
            boolean bl = false;
            ProblemWithRange problemWithNullRange = new ProblemWithRange(problems2.get((int)index), null);
            Pair pair = (Pair)keys.get((int)index);
            OffsetKey startKey = (OffsetKey)pair.component1();
            OffsetKey endKey = (OffsetKey)pair.component2();
            boolean bl2 = rangeCalculatedSuccessfully = newOffsets.containsOffset(startKey) && newOffsets.containsOffset(endKey);
            if (!rangeCalculatedSuccessfully) {
                problemWithRange = problemWithNullRange;
            } else {
                TextRange textRange = new TextRange(newOffsets.getOffset(startKey), newOffsets.getOffset(endKey));
                String string2 = this.getDocument().getText(textRange);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.getText(textRange)");
                boolean textEqualToSnippet = problems2.get((int)index).isEqualToSnippet(string2);
                problemWithRange = !textEqualToSnippet ? problemWithNullRange : (this.isProblemSuppressed(problems2.get((int)index), textRange, highlightedReportData) ? problemWithNullRange : new ProblemWithRange(problems2.get((int)index), textRange));
            }
            arrayList.add(problemWithRange);
        }
        return arrayList2;
    }

    private final boolean isProblemSuppressed(SarifProblem problem, TextRange textRange, HighlightedReportData highlightedReportData) {
        boolean bl;
        block7: {
            Project project2 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
            if (DumbService.Companion.isDumb(project2)) {
                return false;
            }
            PsiElement psiElement = this.myFile.findElementAt(textRange.getStartOffset());
            if (psiElement == null) {
                return false;
            }
            PsiElement element2 = psiElement;
            Language language = LanguageUtil.getFileLanguage((VirtualFile)element2.getContainingFile().getVirtualFile());
            if (language == null) {
                return false;
            }
            Language language2 = language;
            List list2 = LanguageInspectionSuppressors.INSTANCE.allForLanguage(language2);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"INSTANCE.allForLanguage(language)");
            List inspectionSuppressors = list2;
            String string = highlightedReportData.getInspectionsInfoProvider().getSuppressIdByInspection(problem.getInspectionId());
            if (string == null) {
                return false;
            }
            String toolId = string;
            Iterable $this$all$iv = inspectionSuppressors;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    InspectionSuppressor it = (InspectionSuppressor)element$iv;
                    boolean bl2 = false;
                    if (!it.isSuppressedFor(element2, toolId)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return !bl;
    }

    private final HighlightInfo buildHighlightInfo(SarifProblem problem, TextRange textRange, String toolId) {
        if (textRange == null) {
            return null;
        }
        String description2 = SarifProblemKt.buildDescription(problem, true, true);
        String string = DaemonTooltipsUtil.getWrappedTooltipWithCustomReference((String)description2, (String)SarifInspectionDescriptionLinkHandler.Companion.getLinkReferenceToInspection(problem.getInspectionId()), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWrappedTooltipWithCus\u2026tionId),\n      true\n    )");
        String tooltip = string;
        PsiElement element2 = this.myFile.findElementAt(textRange.getStartOffset());
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)QodanaHighlightInfoTypeProvider.Companion.getHighlightTypeInfo());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newHighlightInfo(QodanaH\u2026r.getHighlightTypeInfo())");
        HighlightInfo.Builder builder2 = builder;
        List ignoreActions = new ArrayList();
        if (toolId != null) {
            QodanaSuppressableProblemGroup problemGroup = new QodanaSuppressableProblemGroup(toolId, this.myFile.getVirtualFile());
            builder2.problemGroup((ProblemGroup)problemGroup);
            Object[] suppressActions = problemGroup.getSuppressActions(element2);
            CollectionsKt.addAll((Collection)ignoreActions, (Object[])suppressActions);
        }
        ignoreActions.add(new StopShowingReportAction());
        builder2.registerFix((IntentionAction)new QodanaRootIgnoreIntention(), ignoreActions, null, null, null);
        return builder2.range(textRange).needsUpdateOnTyping(true).description(description2).escapedToolTip(tooltip).create();
    }

    public void doApplyInformationToEditor() {
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), (Collection)this.myHighlightInfos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    public static final /* synthetic */ Project access$getMyProject$p$s1464811777(QodanaReportHighlightingPass $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ PsiFile access$getPsiFileByRevision(QodanaReportHighlightingPass $this, PsiFile myFile, String revisionId) {
        return $this.getPsiFileByRevision(myFile, revisionId);
    }

    public static final /* synthetic */ PsiFile access$getMyFile$p(QodanaReportHighlightingPass $this) {
        return $this.myFile;
    }

    public static final /* synthetic */ PsiFile access$getPsiFileForLastRevision(QodanaReportHighlightingPass $this, PsiFile myFile) {
        return $this.getPsiFileForLastRevision(myFile);
    }

    public static final /* synthetic */ Editor access$getEditor$p(QodanaReportHighlightingPass $this) {
        return $this.editor;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/qodana/highlight/QodanaReportHighlightingPass$Registrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.qodana"})
    public static final class Registrar
    implements TextEditorHighlightingPassFactory,
    TextEditorHighlightingPassFactoryRegistrar,
    DumbAware {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
        }

        @Nullable
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Project project2 = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
            QodanaHighlightedReportService qodanaHighlightedReportService = QodanaHighlightedReportService.Companion.getInstanceIfCreated(project2);
            if (qodanaHighlightedReportService == null) {
                return null;
            }
            QodanaHighlightedReportService highlightedReportService = qodanaHighlightedReportService;
            return new QodanaReportHighlightingPass(file, editor, highlightedReportService);
        }
    }
}

