/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.report;

import com.intellij.openapi.project.Project;
import com.jetbrains.qodana.sarif.model.SarifReport;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.InterruptibleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.coroutines.QodanaDispatchersKt;
import org.jetbrains.qodana.report.FileReportDescriptor;
import org.jetbrains.qodana.report.FromFileReportDescriptorBuilderKt;
import org.jetbrains.qodana.report.ReportDescriptorBuilder;
import org.jetbrains.qodana.report.ReportReader;
import org.jetbrains.qodana.report.ReportResult;
import org.jetbrains.qodana.report.SarifKt;
import org.jetbrains.qodana.report.ValidatedSarif;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/qodana/report/FromFileReportDescriptorBuilder;", "Lorg/jetbrains/qodana/report/ReportDescriptorBuilder;", "Lorg/jetbrains/qodana/report/FileReportDescriptor;", "path", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/nio/file/Path;Lcom/intellij/openapi/project/Project;)V", "reportPath", "createReportDescriptor", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.qodana"})
public final class FromFileReportDescriptorBuilder
implements ReportDescriptorBuilder<FileReportDescriptor> {
    @NotNull
    private final Project project;
    @NotNull
    private final Path reportPath;

    public FromFileReportDescriptorBuilder(@NotNull Path path, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.toAbsolutePath()");
        this.reportPath = path2;
    }

    @Override
    @Nullable
    public Object createReportDescriptor(@NotNull Continuation<? super FileReportDescriptor> $completion) {
        return InterruptibleKt.runInterruptible((CoroutineContext)QodanaDispatchersKt.getQodanaDispatchers().getIO(), (Function0)((Function0)new Function0<FileReportDescriptor>(this){
            final /* synthetic */ FromFileReportDescriptorBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final FileReportDescriptor invoke() {
                ReportResult<ValidatedSarif, ReportReader.ReaderError> readReportResult = ReportReader.INSTANCE.readReport(FromFileReportDescriptorBuilder.access$getReportPath$p(this.this$0));
                if (readReportResult instanceof ReportResult.Fail) {
                    ((ReportReader.ReaderError)((ReportResult.Fail)readReportResult).getError()).spawnNotification(FromFileReportDescriptorBuilder.access$getProject$p(this.this$0), (Function1)new Function1<ReportReader.ReaderError, String>(this.this$0){
                        final /* synthetic */ FromFileReportDescriptorBuilder this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final String invoke(@NotNull ReportReader.ReaderError it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return FromFileReportDescriptorBuilderKt.getReportFileErrorNotificationContent(FromFileReportDescriptorBuilder.access$getReportPath$p(this.this$0), it);
                        }
                    });
                    return null;
                }
                if (!(readReportResult instanceof ReportResult.Success)) {
                    throw new NoWhenBranchMatchedException();
                }
                SarifReport report2 = ((ValidatedSarif)((ReportResult.Success)readReportResult).getLoadedSarifReport()).getSarif();
                String guid = SarifKt.getGuid(report2);
                String string = SarifKt.getId(report2);
                if (string == null) {
                    string = guid;
                }
                String name = string;
                return new FileReportDescriptor(FromFileReportDescriptorBuilder.access$getReportPath$p(this.this$0), SarifKt.isQodanaReport(report2), guid, name, FromFileReportDescriptorBuilder.access$getProject$p(this.this$0));
            }
        }), $completion);
    }

    public static final /* synthetic */ Path access$getReportPath$p(FromFileReportDescriptorBuilder $this) {
        return $this.reportPath;
    }

    public static final /* synthetic */ Project access$getProject$p(FromFileReportDescriptorBuilder $this) {
        return $this.project;
    }
}

