/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.OutputFormat;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.OutputFormatKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;
import org.jetbrains.qodana.staticAnalysis.stat.UsageCollector;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\b\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\b\u0010\u0007\u001a\u00020\u0005H\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"DEFAULT_OUTPUT_FORMAT", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;", "getDEFAULT_OUTPUT_FORMAT", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;", "QODANA_FORMAT", "", "getOutputFormat", "getOutputFormatName", "intellij.qodana"})
public final class OutputFormatKt {
    @NotNull
    public static final String QODANA_FORMAT = "qodana.format";
    @NotNull
    private static final OutputFormat DEFAULT_OUTPUT_FORMAT = OutputFormat.SARIF_AND_PROJECT_STRUCTURE;

    @NotNull
    public static final OutputFormat getDEFAULT_OUTPUT_FORMAT() {
        return DEFAULT_OUTPUT_FORMAT;
    }

    @NotNull
    public static final OutputFormat getOutputFormat() {
        String formatName = OutputFormatKt.getOutputFormatName();
        try {
            return OutputFormat.valueOf(formatName);
        }
        catch (IllegalArgumentException e) {
            String validValues2 = ArraysKt.joinToString$default((Object[])OutputFormat.values(), null, null, null, (int)0, null, (Function1)getOutputFormat.validValues.1.INSTANCE, (int)31, null);
            throw new QodanaException("Invalid format '" + formatName + "' in system property 'qodana.format'. Valid values are " + validValues2 + ".");
        }
    }

    private static final String getOutputFormatName() {
        UsageCollector.Companion.Environment environment;
        String formatName = System.getProperties().getProperty(QODANA_FORMAT);
        if (formatName != null) {
            return formatName;
        }
        String string = System.getenv("QODANA_ENV");
        if (string == null) {
            string = "";
        }
        return Intrinsics.areEqual((Object)(environment = UsageCollector.Companion.splitEnv$intellij_qodana(string)).getSystem(), (Object)"teamcity") ? "INSPECT_SH_FORMAT" : DEFAULT_OUTPUT_FORMAT.name();
    }
}

